#!/bin/sh

GET_TIME_SEC="date +%s"
TEST_TIMEOUT=10
SAVED_FILE=/tmp/mvt/saved
SAVING_FILE=/tmp/mvt/saving
MUT_NAME=mut

#  -
rm -f $SAVED_FILE
rm -f $SAVING_FILE

#     
pkill -USR1 $MUT_NAME
res=$?

if [ "x$res" == "x1" ]; then
	echo "$MUT_NAME not found"
	exit 1
fi

#  TEST_TIMEOUT ,   - saving
TIMEOUT_KS_INITIAL=$($GET_TIME_SEC)

while ((1)); do
	let TIMEOUT_KS=$($GET_TIME_SEC)-$TIMEOUT_KS_INITIAL
	if [ "$TIMEOUT_KS" -ge "$TEST_TIMEOUT" ]; then
		echo Timeout. Old $MUT_NAME?
		exit 1
	fi
	
	#   - - 
	if [ -f $SAVING_FILE ] ; then
		echo Saving
		break
	fi
	
	sleep 1
done

#     
while ((1)); do
	#   - - 
	if [ -f $SAVED_FILE ] ; then
		echo AT Saved
		break
	fi
	
	# ,    
	pkill -0 $MUT_NAME
	res=$?

	if [ "x$res" == "x1" ]; then
		echo "$MUT_NAME is dead"
		exit 1
	fi
	
	sleep 1
done

let ELAPSED_TIME=$($GET_TIME_SEC)-$TIMEOUT_KS_INITIAL
echo Trends saved in $ELAPSED_TIME sec.

exit 0
