#!/bin/bash
# Создать "клон" системы DevLink

. /gsw/etc/krug.env

CACHE_DIR=${GSW_REP}cache
CLONE_DIR=/tmp/clone
PKG_INFO_DIR=/var/lib/dpkg/info

SETTINGS_TAR=/tmp/clone_settings.tar
SERVS_LIST=/tmp/servs.lst

CLONE_NAME=unknown
CLONE_VERS=unknown
CLONE_ARCH=unknown
CLONE_DESC=unknown

DEB_LIST=

clone_prepare() {
	mkdir -p $CLONE_DIR$CACHE_DIR
	mkdir -p $CLONE_DIR/DEBIAN
	mkdir -p $CLONE_DIR/tmp
}

get_flag() {
	[[ "$1" == *.deb ]] && echo "-I" || echo "-p"
}

get_pkg_name() {
	flag=$(get_flag $1)
	dpkg $flag $1 | grep Package | awk '{print $2}'
}
get_pkg_vers() {
	flag=$(get_flag $1)
	dpkg $flag $1 | grep Version | awk '{print $2}'
}
get_pkg_arch() {
	flag=$(get_flag $1)
	dpkg $flag $1 | grep Architecture | awk '{print $2}'
}
get_pkg_desc() {
	flag=$(get_flag $1)
	dpkg $flag $1 | grep Description | awk -F ": " '{print $2}'
}
get_pkg_type() {
	flag=$(get_flag $1)
	dpkg $flag $1 | grep PkgType | awk '{print $2}'
}

get_base_pkg_name() {
	name=$(fw_printenv bpkg 2>/dev/null)
	if [ "x$?" == "x0" ]; then
		echo $name | awk -F"=" '{print $2}'
	else
		echo ""
	fi
}

create_deb_control() {
	file=$CLONE_DIR/DEBIAN/control
	vers=$CLONE_VERS
	[ "x$vers" == "xunknown" ] && vers=1.0
	touch $file
	chmod 0644 $file
	cat > $file <<EOF
Package: clone-$CLONE_NAME
Version: $vers
Priority: optional
Architecture: $CLONE_ARCH
Maintainer: КРУГ-Софт
Depends: $CLONE_NAME (= $vers)
Description: Клон системы $CLONE_DESC
PkgType: clone
EOF
}
create_deb_postinst() {
	file=$CLONE_DIR/DEBIAN/postinst
	sh_file=/tmp/postinst.sh
	touch $file
	chmod 0755 $file
	echo >> $file
	cat > $file <<EOF
#!/bin/sh
set -e
$sh_file &
EOF
	file=$CLONE_DIR$sh_file
	touch $file
	chmod 0777 $file
	echo '#!/bin/sh
wait_reg() {
  check_file=/tmp/dl-reg
  if [ -f "$check_file" ]; then
    while((1)); do
      fl=$(cat $check_file)
      [ "x$fl" == "x0" ] && break
      sleep 1
    done
  fi
  sleep 1
}
sleep 4
' >> $file
	if [ -n "$DEB_LIST" ]; then
		DEB_LIST=$(dl-sort-deblist "$DEB_LIST")
		for d in $DEB_LIST; do
			echo 'echo "1" > /tmp/dl-reg' >> $file
			echo "dpkg -i --force-overwrite --force-confdef $d" >> $file
			echo "wait_reg" >> $file
		done
	fi
	[ -f "${CLONE_DIR}${SETTINGS_TAR}.gz" ] && echo "tar xzf $SETTINGS_TAR.gz -C /" >> $file
	[ -f "${CLONE_DIR}${SERVS_LIST}" ] && echo "/usr/bin/dl-act-servs ${SERVS_LIST}" >> $file
	echo "/gsw/prg_mode once" >> $file
}

srvk_dump() {
	[ -n "$DEVLINK_BASE_PATH" ] && trends_settings=$DEVLINK_BASE_PATH || trends_settings=${GSW}krugdb
	tar rf ${CLONE_DIR}${SETTINGS_TAR} $trends_settings/*.xml &> /dev/null

	[ -n "$PRG" ] && prg_settings=$PRG || prg_settings=${GSW}prg
	tar rf ${CLONE_DIR}${SETTINGS_TAR} $prg_settings &> /dev/null

	tar rf ${CLONE_DIR}${SETTINGS_TAR} ${GSW}dic/*.dic &> /dev/null

	tar rf ${CLONE_DIR}${SETTINGS_TAR} ${GSW}system/nln*.dat &> /dev/null

	tar rf ${CLONE_DIR}${SETTINGS_TAR} ${GSW}guicfg &> /dev/null

	tar rf ${CLONE_DIR}${SETTINGS_TAR} ${GSW_ETC}ppp.cfg ${GSW_ETC}ntp.cnf \
		${GSW_ETC}localtime ${GSW_ETC}timezone ${GSW_ETC}ppp/options \
		${GSW_ETC}krug.env &> /dev/null
}

servs_dump() {
	file=${CLONE_DIR}${SERVS_LIST} 
	touch $file
	chmod 0664 $file
	pattern='.*S[0-9][0-9]'
	find /gsw/etc/rc.d/rc0.d -type l | sed "/^$pattern/ s//w_/" | cat > $file
	find /gsw/etc/rc.d/rc1.d -type l | sed "/^$pattern/ s//p_/" | cat >> $file
}

clone_prepare

name=$(get_base_pkg_name)
if [[ "x$name" != "x" ]]; then
	CLONE_NAME=$(get_pkg_name $name)
	CLONE_VERS=$(get_pkg_vers $name)
	CLONE_ARCH=$(get_pkg_arch $name)
	CLONE_DESC=$(get_pkg_desc $name)
	y=$(cat $PKG_INFO_DIR/${name}.conffiles)
	tar rf ${CLONE_DIR}${SETTINGS_TAR} $y &> /dev/null
fi

debs=$(ls $CACHE_DIR | grep -c "\.deb")
if [ "$debs" -gt "0" ]; then
	for pkg in $CACHE_DIR/*.deb; do
		pkg_name=$(get_pkg_name $pkg)
		pkg_type=$(get_pkg_type $pkg)
	
		if [[ "x$pkg_type" != "xbase" && "x$pkg_type" != "xclone" ]]; then
			DEB_LIST="$DEB_LIST$pkg "
			cp $pkg ${CLONE_DIR}${pkg} &> /dev/null
		fi
	
		if [ -f "$PKG_INFO_DIR/${pkg_name}.conffiles" ]; then
			y=$(cat $PKG_INFO_DIR/${pkg_name}.conffiles)
			y=$(echo $y | sed 's/\/gsw\/settings\/services.ini//')
			tar rf ${CLONE_DIR}${SETTINGS_TAR} $y &> /dev/null
		fi
	done
fi

srvk_dump
servs_dump

[ -f "${CLONE_DIR}${SETTINGS_TAR}" ] && gzip ${CLONE_DIR}${SETTINGS_TAR}

create_deb_control
create_deb_postinst

debfile=/tmp/filestore/clone-${CLONE_NAME}-${CLONE_VERS}-${CLONE_ARCH}.deb
dpkg --build ${CLONE_DIR} $debfile &> /dev/null
rm -fr ${CLONE_DIR}

echo "/filestore/clone-${CLONE_NAME}-${CLONE_VERS}-${CLONE_ARCH}.deb"

exit 0
