#!/bin/bash
#Очистка системы от пакетов, не являющихся базовыми.

. /gsw/etc/krug.env

CACHE_DIR=${GSW_REP}cache
SERVS_DIR=${GSW_ETC}rc.d/init.d

get_flag() {
	[[ "$1" == *.deb ]] && echo "-I" || echo "-p"
}
get_pkg_name() {
	flag=$(get_flag $1)
	dpkg $flag $1 | grep Package | awk '{print $2}'
}
get_pkg_type() {
	flag=$(get_flag $1)
	dpkg $flag $1 | grep PkgType | awk '{print $2}'
}

stop_servs() {
	servs=$(dpkg -s $1 | grep Service | awk -F", " '{print $2}')
	for s in $servs; do
		[ -x "$SERVS_DIR/$s" ] && $SERVS_DIR/$s stop
	done
}

wait_reg() {
	check_file=/tmp/dl-reg
	if [ -f "$check_file" ]; then
		while((1)); do
			fl=$(cat $check_file)
			[ "x$fl" == "x0" ] && break
			sleep 1
		done
	fi
	sleep 1
}

check_pkg_install() {
	pattern="Status: "
	status=$(dpkg -s $1 | grep "$pattern" | sed "s/$pattern//")
	[ "x$?" == "x1" ] && return 1
	s1=$(echo "$status" | awk '{print $1}')
	s2=$(echo "$status" | awk '{print $2}')
#	s3=$(echo "$status" | awk '{print $3}')
	[[ "x$s1" == "xinstall" && "x$s2" == "xok" ]] && return 0
	return 1
}

debs=$(ls $CACHE_DIR | grep -c "\.deb")
if [ "$debs" -gt "0" ]; then
	for pkg in $CACHE_DIR/*.deb; do
		pkg_name=$(get_pkg_name $pkg)
		pkg_type=$(get_pkg_type $pkg)
		if [[ "x$pkg_type" != "xbase" && "x$pkg_type" != "xclone" ]]; then
			check_pkg_install $pkg_name
			if [ "x$?" == "x0" ]; then
				stop_servs $pkg_name
				sleep 3
				echo "2" > /tmp/dl-reg			
				dpkg -P "$pkg_name"
				wait_reg
			fi
			rm -f "$pkg"
		fi
	done
fi

exit 0
