#!/usr/bin/perl
require './parse_file-lib.pl';
require '../waitbox.pl';
use Tie::IxHash;
use Switch;
my $INIFILE;
my $script = "<script language=javascript src='../WaitBox.js'> </script>"."\n".
             "<script language=javascript src='validate.js'> </script>"."\n".
             '<meta http-equiv="Content-Type" content="text/html"; charset="utf8">';
print ui_print_header(undef,$text{'GPRS_title'},undef,undef,1,1,undef,undef,$script,'onload="hideErors(event);OnLoadPage()" onsubmit="ShowWaitBox()"');
ShowWaitBox("Выполняется сохранение настроек...","none");
print  '<div id="main_div" style="display:block;">';
print ui_form_start('SaveData.cgi','post',undef);
BuildInterface();
print ui_form_end();
print "</div>";


sub BuildInterface()
{
my %KrugSettings = LoadKrugSettings(); 
$path = $KrugSettings{'GSW_GUICFG'}.'gprs/'."GPRS_ADDIFace.config";
my %defValues = ParseInterfaceConfig($path);
my %FileData = LoadConfig();
my $filename = $KrugSettings{"GSW_GUICFG"}."gprs/GPRS_ADD.sect";
my %SectionFileData = GetIniFileData($filename);
%FileData = RestoreDefaults(\%defValues,\%FileData);
my @table = ();
 #my $editEvents = 'onkeydown="veryfiData_OnKeyDown(event)" onfocus="onFocus(event)"';
 my $editEvents = 'onfocus="onFocus(event)"';
  
foreach $s(sort {$SectionFileData{$a}{'Order'}<=>$SectionFileData{$b}{'Order'}} keys %SectionFileData)
{
  $section= '['.$SectionFileData{$s}{'Name'}.']';
  $_=$section;
  print '<p align="center">'.'<font color="blue"><b>'.$SectionFileData{$s}{'Caption'}.'</b></font></p>';
  print &ui_columns_start(
  [$text{'ParamHeader'},$text{'ValueHeader'},""]
  ,100,0
  );
  my $ifaceSect = $section;
  my %ifaceParams=%{$defValues{$ifaceSect}};
  for (my $i=0;$i<scalar(keys %ifaceParams);$i++)
  {
       my @cols=();
     foreach my $ifaceParam (sort keys %ifaceParams)
     {
       if($ifaceParams{$ifaceParam}{'Order'}==($i+1))
       {
         my $cfgparam = $ifaceParams{$ifaceParam}{'Param'};
         if(!defined($FileData{$section}{$cfgparam}))
         {
            $FileData{$section}{$cfgparam}=$ifaceParams{$ifaceParam}{'DefValue'};
         }
           my $error_ctrl=ui_textbox($cfgparam.$section."_err","",60,0,150,"id=".'"'.$cfgparam.$section."_err".'" '.$editEvents);          
            switch ($ifaceParams{$ifaceParam}{'Type'})
            {
             case "ComboBox" 
             {        
            	my %comports = undef;
                my @tmpvalues = split(/\,/,$ifaceParams{$ifaceParam}{'Values'});
                my @values;
			  foreach $val (@tmpvalues)
			  {
			  	 push(@values,[split('-',$val)]);
			  }	
              my $value=$FileData{$section}{$cfgparam};
    	      my $control='';
    	      if(defined($ifaceParams{$ifaceParam}{'OnChange'}))
    	      {
    	      	$control = ui_select($cfgparam.$section,[$value],[@values],1,0,0,0,"OnChange=\"".$ifaceParams{$ifaceParam}{'OnChange'}.'"');
    	      }
    	      else
    	      {
    	      	$control = ui_select($cfgparam.$section,[$value],[@values],1,0);    	      	
    	      }
              push(@cols, ["<p style=\"padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;\">".html_escape($ifaceParams{$ifaceParam}{'Caption'})."</p>",$control,$error_ctrl]); 
             }       
            case "EditBox" 
            {
             my $value=$FileData{$section}{$cfgparam};          
             $editEvents = 'onkeydown='.$ifaceParams{$ifaceParam}{'OnKeyDown'}.' onfocus='.$ifaceParams{$ifaceParam}{'OnFocus'};
             my $control = ui_textbox($cfgparam.$section,$value,50,0,100,"id=".'"'.$cfgparam.$section.'" '.$editEvents);
             push(@cols,[$ifaceParams{$ifaceParam}{'Caption'},$control,$error_ctrl]); 
            }
            case "Password" 
            {
             my $value=$FileData{$section}{$cfgparam};
             $editEvents = 'onkeydown='.$ifaceParams{$ifaceParam}{'OnKeyDown'}.' onfocus='.$ifaceParams{$ifaceParam}{'OnFocus'};
             my $control = ui_password($cfgparam.$section,$value,50,0,100,"id=".'"'.$cfgparam.$section.'" '.$editEvents);
             push(@cols,[$ifaceParams{$ifaceParam}{'Caption'},$control,$error_ctrl]); 
            }
           }                      
         }
      
      }
         print ui_columns_row(@cols);        
  }
   print &ui_columns_end();
 }
 print "<p></p>";  
 print '<p align="center">',ui_submit($text{'SubmitButton'},$text{'SubmitButton'},0,'onclick="veryfiData_onSubmit(event)"'),"</p>";
 
}


sub LoadConfig()
{
 my %KrugSettings = LoadKrugSettings();
 my $filename = $KrugSettings{"GSW_SETTINGS"}."gprs_mgr.ini";
 my %Data = GetIniFileData($filename);
 return %Data;
}
