#!/usr/bin/perl
require './parse_file-lib.pl';
require '../waitbox.pl';

use feature ":5.10";
my $INIFILE;
my $script = "<script language=javascript src='../WaitBox.js'> </script>"."\n".
             "<script language=javascript src='validate.js'> </script>".
             "\n".'<meta http-equiv="Content-Type" content="text/html"; charset="utf8">';
print ui_print_header(undef,$text{'GPRS_title'},undef,undef,1,1,undef,undef,$script,'onload="hideErors(event)"');
ShowWaitBox("Выполняется обновление информации...","none");
print  '<div id="main_div" style="display:block;">';
print ui_form_start('SaveData.cgi','post',undef);
BuildInterface();
print ui_form_end();
print "</div>";

sub BuildInterface()
{
my %KrugSettings = LoadKrugSettings(); 
$path = $KrugSettings{'GSW_GUICFG'}.'gprs/'."GPRS_DIAGIFace.config";
my %defValues = ParseInterfaceConfig($path);
if(!(-e "/gsw/gm_m50"))
{
  print "<p align=\"center\"> <font color=\"red\"><b>Утилита диагностики GPRS отсутствует.<br> Необходимо переустановить пакет модуля удалённых соединений (МУС)</b></font></p>";
  exit;	
}
my %FileData = LoadConfig();
%FileData = RestoreDefaults(\%defValues,\%FileData);
my @table = ();
 #my $editEvents = 'onkeydown="veryfiData_OnKeyDown(event)" onfocus="onFocus(event)"';
 my $editEvents = 'onfocus="onFocus(event)"';
  my $j=0;  
foreach $section(sort keys %FileData)
{
  
  $_=$section;
  print '<p align="center">'.'<font color="blue"><b>'.$section.'</b></font></p>';
  print &ui_columns_start(
  [$text{'ParamHeader'},$text{'ValueHeader'},""]
  ,100,0
  );
  my $ifaceSect = $section;
  my %ifaceParams=%{$defValues{$ifaceSect}};
#  for (my $i=0;$i<scalar(keys %ifaceParams);$i++)
  {
     foreach my $ifaceParam (sort {$ifaceParams{$a}{'Order'}<=>$ifaceParams{$b}{'Order'}} keys %ifaceParams)
     {
       my @cols=();
#       if($ifaceParams{$ifaceParam}{'Order'}==($i+1))
       {
         my $cfgparam = $ifaceParams{$ifaceParam}{'Param'};
         if(!defined($FileData{$section}{$cfgparam}))
         {
            $FileData{$section}{$cfgparam}=$ifaceParams{$ifaceParam}{'DefValue'};
         }
           my $error_ctrl=ui_textbox($cfgparam.$section."_err","",60,0,150,"id=".'"'.$cfgparam.$section."_err".'" '.$editEvents);          
            given ($ifaceParams{$ifaceParam}{'Type'})
            {
             when("ComboBox") 
             {        
            	my %comports = undef;
              @values = split(/\,/,$ifaceParams{$ifaceParam}{'Values'});
              my $value=$FileData{$section}{$cfgparam};
    	        my $control = ui_select($cfgparam.$section,[$value],[@values],1,0);
              my $submit_btn = undef;
              if($ifaceSect=~/Управление/)
              {
                if($cfgparam=~/ActiveSIM/)
                {
                my $ref = "ONCLICK=".'"ShowWaitBox('."'Выполняется сохранение настроек...'".');ChangeActiveSIM(event)"';
                 $submit_btn = ui_button($text{'SubmitButton'},$text{'SubmitButton'},0,$ref);
                } else 
                {
                  if($cfgparam=~/Ban_transition/)
                  {
#                  my $ref = "ONCLICK="."window.location.href='changeSim.cgi'";
                   my $ref = "ONCLICK=".'"ShowWaitBox('."'Выполняется сохранение настроек...'".');Ban_transition(event)"';
                   $submit_btn = ui_button($text{'SubmitButton'},$text{'SubmitButton'},0,$ref);                
                  }
                }
              }
              push(@cols, ["<p style=\"padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;\">".html_escape($ifaceParams{$ifaceParam}{'Caption'})."</p>",$control,$submit_btn]); 
             }       
            when ("EditBox") 
            {
             my $value=$FileData{$section}{$cfgparam};          
 #            $editEvents = 'onkeydown='.$ifaceParams{$ifaceParam}{'OnKeyDown'}.' onfocus='.$ifaceParams{$ifaceParam}{'OnFocus'};
             my $control = ui_textbox($cfgparam.$section,$value,50,0,100,"id=".'"'.$cfgparam.$section.'" '." readonly=".'"readonly"');
             push(@cols,[$ifaceParams{$ifaceParam}{'Caption'},$control,$submit_btn]); 
            }
            when("Password") 
            {
             my $value=$FileData{$section}{$cfgparam};
             $editEvents = 'onkeydown='.$ifaceParams{$ifaceParam}{'OnKeyDown'}.' onfocus='.$ifaceParams{$ifaceParam}{'OnFocus'};
             my $control = ui_password($cfgparam.$section,$value,50,0,100,"id=".'"'.$cfgparam.$section.'" '.$editEvents);
             push(@cols,[$ifaceParams{$ifaceParam}{'Caption'},$control,$submit_btn]); 
            }
           }                      
         }
         print ui_columns_row(@cols,undef,$j%2);
         $j++;        
      }
  }
   print &ui_columns_end();
  if($section=~/Диагностика/)
  {
   my $ref = "ONCLICK=".'"ShowWaitBox('."'Выполняется обновление информации...'".'); window.location.href='."'index.cgi'".'"';;
   print '<p align="center">',ui_button("Обновить","Обновить",0,$ref),"</p>"; 
   print "<p></p>";              
            
  }
 } 
   print '<p><b>*Примечание:</b> Смена активной SIM возможна в режиме "Автоматическое резервирование SIM-карт"</p>';              

}


sub LoadConfig()
{
 my %KrugSettings = LoadKrugSettings();
 my %Data = ();
 my $cmdline = "/gsw/gm_m50 -a";
 @output=`$cmdline`;
for $s (@output) 
{
 $_ = $s;
 if(/(\.*)\s*\=\s*(\.*)/)
 {
     $s ="$`";    
     my $s1="$'";
     if($s=~/ConnectionState/)
     {
       if($s1==0)
       {
          $s1 = "Не установлено"
       }
       else
       {
          $s1 = "Установлено"       
       }
     }
     if($s=~/Ban_transition/)
     {
       if($s1==0)
       {
          $s1 = "Разрешён"
       }
       else
       {
          $s1 = "Запрещён"       
       }     
     }
     if($s=~/ActiveSIM/)
     {
       if($s1==0)
	{
	  $s1='----'
	} 
        else
       {
	  $s1="SIM".$s1;
       }     
     }
     $Data{'[Диагностика]'}{$s} = $s1;   
 }
}
 return %Data;
}
