#!/usr/bin/perl
use WebminCore;
use feature ":5.10";
init_config();
use CGI::Lite;
use POSIX qw(strftime);
$cgi=new CGI::Lite();
my %params    = $cgi->parse_form_data();
my $Interface=$params{'iface'};
my $Stat=$params{'stat'};

print ui_print_header(undef,undef,undef,undef,1,1,undef,undef,undef,'');
print ui_form_start();
my $result= GetData($Interface,$Stat);
if($result eq "0")
{
	print '<p><b><font color="Red">По интерфейсу '. $Interface.' статистика не ведётся</b></p>';
}
else
{
  print &ui_columns_start(["Дата","Получено","Отправлено","Трафик"],50,0);
  print $result;  
  print &ui_columns_end();
}
my $result=CheckStat();
if($result==0)
{
	print '<p><b><font color="Red">Учёт трафика не ведётся. Служба учёта трафика не запущена. </b></p>';	
}
else
{
	print '<p><b><font color="Green">Ведётся учёт трафика </b></p>';		
}
print ui_form_end();

sub GetData()
{
	my ($iface,$stat)=@_;
	my @output=`vnstat --dumpdb -i $iface|grep -E "^$stat;[0-9]+;[^0]"|sed -e "s/$stat;//"`;
	my $result=();
	if (scalar(@output)==(0+0))
	 {
	 	return "0";
	 }
	 my $total_recv=0;
	 my $total_transmit=0;
	foreach $item (@output)
	{
   	my $rx=0;
   	my $tx=0;
	  my @itemdata=split(';',$item);
	  
	  my $timestr=();
	  given($stat)
	  {
	  	when("h")
	  	{
	  	   $timestr=strftime("%e %b %Y %H:%M:%S",localtime($itemdata[1]));
	  	}
	  	when("d")
	  	{
	  	   $timestr=strftime("%e %b %Y",localtime($itemdata[1]));	  		
	  	}
	  	when("m")
	  	{
	  	  $timestr=strftime("%b %Y",localtime($itemdata[1]));		
	  	}
	  }
	  if($itemdata[1]==0)
	  {
	  	next;
	  }
      if($stat eq "h")
      {
       $rx=$itemdata[2];
       $tx=$itemdata[3];
        $result=$result.ui_columns_row([
                           '<font color="black">'.$timestr.'</font>',
                           '<p style="padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;" align="center"><font color="#660000"><b>'.$rx.' KB</b></font></p>',
                           '<p style="padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;" align="center"><font color="#006600"><b>'.$tx.' KB</b></font></p>',
                           '<p style="padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;" align="center"><font color="black"><b>'.($rx+$tx).' KB</b></font></p>']);
      }
      else
      {
      	$rx=($itemdata[2]+($itemdata[4]/1024));
      	$tx=($itemdata[3]+($itemdata[5]/1024));
        $result=$result.ui_columns_row([
                           '<font color="black">'.$timestr.'</font>',
                           '<p style="padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;" align="center"><font color="#660000"><b>'.sprintf("%.2f",$rx).' MB</b></font></p>',
                           '<p style="padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;" align="center"><font color="#006600"><b>'.sprintf("%.2f",$tx).' MB</b></font></p>',
                           '<p style="padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;" align="center"><font color="black"><b>'.sprintf("%.2f",$rx+$tx).' MB</b></font></p>']);      	
      }
      $total_recv=$total_recv+$rx;
      $total_transmit=$total_transmit+$tx;
	}
	if($stat eq "h")
	{
    $result=$result.ui_columns_row([
                           '<p style="padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;background-color:#A8A8A8"><font color="9900FF"> <b>'."ИТОГО:".'</b></font></p>',
                           '<p style="padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;background-color:#A8A8A8"align="center"><font color="#660000"><b>'.sprintf("%.2f",$total_recv).' КВ</b></font></p>',
                           '<p style="padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;background-color:#A8A8A8"align="center"><font color="#006600"><b>'.sprintf("%.2f",$total_transmit).' KB</b></font></p>',
                           '<p style="padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;background-color:#A8A8A8"align="center"><font color="black"><b>'.sprintf("%.2f",$total_recv+$total_transmit).' KB</b></font></p>']);		
	}
	else
	{
    $result=$result.ui_columns_row([
                           '<p style="padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;background-color:#A8A8A8"><font color="9900FF"> <b>'."ИТОГО:".'</b></font></p>',
                           '<p style="padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;background-color:#A8A8A8"align="center"><font color="#660000"><b>'.sprintf("%.2f",$total_recv).' MB</b></font></p>',
                           '<p style="padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;background-color:#A8A8A8"align="center"><font color="#006600"><b>'.sprintf("%.2f",$total_transmit).' MB</b></font></p>',
                           '<p style="padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;background-color:#A8A8A8"align="center"><font color="black"><b>'.sprintf("%.2f",$total_recv+$total_transmit).' MB</b></font></p>']);
	}                             		
	return $result;
}
sub CheckStat()
{
	my $output = `/usr/sbin/vnstat_ctrl check`;
	if($output=~/off/)
	{
		return 0;
	}
	else
	{
		return 1;
	}
}