#!/usr/bin/perl
my $INIFILE;
use WebminCore;
init_config();
my $script = "<script language=javascript src='../WaitBox.js'> </script>"."\n".
             "<script language=javascript src='getdata.js'> </script>".
             "\n".'<meta http-equiv="Content-Type" content="text/html"; charset="utf8">';
print ui_print_header(undef,$text{'GPRS_title'},undef,undef,1,1,undef,undef,$script,'');
if(IsSupport()!=1)
{
print <<EOF
   <p align="center">
    <font color="red"><b>Для работы данного плагина необходимо установить пакет Модуля удалённых соединений версии 1.2 или выше</b></font> 
  </p>
EOF
;
	exit;
}

print ui_form_start();
my @values=getIfaces();
my $ui_combo_Interface=ui_select("iface",'eth0',[@values],1,0,0,0,'id="iface"');
@values=getStatTypes();
my $ui_combo_TypeStat=ui_select("stat",[0],@values,1,0,0,0,'id="stat"');
my $button_refresh=ui_button("Обновить","refresh",0,'onclick="update()"');

print <<EOF 
     <table width="30%" >
        <tr width="30%">
         <td>
           <font color="blue">Наименование интерфейса</font>
         </td>
         <td>
         $ui_combo_Interface
         </td>
        </tr>
        <tr width="30%">
         <td>
           <font color="blue">Тип статистики</font>
         </td>
         <td>
         $ui_combo_TypeStat
         </td>
        </tr>
        <tr width="100%">
        </tr>
        <tr width="100%">
         <td>
		     <p align="center"> 
      			 $button_refresh
    		 </p>
         </td>
        </tr>
     </table>
     <Div id="DataTable">
     </Div>
	 <script type="text/javascript">
		function timeMsg()
		{
			var t=setInterval("update()",5*60*1000);
			update();
		}
		timeMsg();
    </script>
EOF
;
print ui_form_end();

sub getIfaces()
{
	my @output=`vnstat --iflist|sed -re "s/Available interfaces: //g; s/lo//g; s/ /\\n/g"`;
	my @ifaces=();
	foreach my $iface(@output)
	{	
		if(length($iface)==1)
		{
			next;
		}
		my @tmp=[$iface,$iface];
		push(@ifaces,@tmp);
	}
	return @ifaces; 
}
sub getStatTypes()
{
	my @types=[['h','За сутки'],['d','За месяц'],['m','За год']];
	return @types; 	
}
sub IsSupport()
{
  my $res=1;
  my $output=`dpkg -p mus |grep Version:|sed -r "s/Version:\\s+//g"`;
  my $ver_compare_result=Compare_Versions($output,"1.2");
  if ($ver_compare_result==-1) #$output<1.2
  {
  	$res=0;
  }    
  return $res;	
}
sub Compare_Versions()
{
 (my $left,my $right)=@_;
  my @l=split(/\./,$left);
  my @r=split(/\./,$right);
  
  if(scalar(@l)>scalar(@r))
  {
  	for($i=0;$i<(scalar(@l)-scalar(@r));$i++)
  	{
  		push(@r,"0");
  	}
  }
  if(scalar(@r)>scalar(@l))
  {
  	for($i=0;$i<(scalar(@r)-scalar(@l));$i++)
  	{
  		push(@l,"0");
  	}  	
  }
  my $result;
 for ($i=0;$i<scalar(@l);$i++)
 {
    if($l[$i]>$r[$i])
    {
      $result=1;
      return $result;	
    } else
    {
	    if($l[$i]==$r[$i])
	    {
	      $result=0;
	    }
	    else
	    {
		    if($l[$i]<$r[$i])
		    {
		      $result=-1;
		      return $result;	
		    }	    	
	    }    	
    } 	
 } 
 return $result;	
}