#!/usr/bin/perl
require './parse_file-lib.pl';
use feature ":5.10";
my $INIFILE;
my $script = "<script language=javascript src='validate.js'> </script>"."\n".'<meta http-equiv="Content-Type" content="text/html"; charset="utf8">';
print ui_print_header(undef,$text{'IP2RS_title'},undef,undef,1,1,undef,undef,$script,'onload="hideErors(event)"');
undef $script;
print ui_form_start('submit.cgi','post',undef);
BuildInterface();
print ui_form_end();


sub BuildInterface()
{
my @EthernetInterfaces = GetEthernetInterfaces();
my %COMInterfaces = GetCOMInterfaces();

my %KrugSettings = LoadKrugSettings();
my $path = $KrugSettings{'GSW_SETTINGS'}."/ser2net.conf";   
my %FileData = LoadConfig($path);

$res=`cat $path | grep -c \\#\\"`;
$res=~s/\n//g;
if($res==0)
{
 $path = $KrugSettings{'GSW_GUICFG'}."/IP2RS.data";   	
 %FileData = ParseKrugKntrIniFile($path);
}
$path = $KrugSettings{'GSW_GUICFG'}."/IP2RS/interface.config";
my %defValues = ParseInterfaceConfig($path);
my @table = ();
my $i=0;
print &ui_columns_start(
["",$text{'ComPortHeader'},$text{'EthernetInterfaceHeader'},$text{'EthernetPortHeader'},$text{'timeout'},"Параметры",""]
,100,0
);
foreach my $COM(sort{
	                 $s1=$COMInterfaces{$a}{'name'};
	                 $s2=$COMInterfaces{$b}{'name'}; 
	                 $s1=~s/ttyS//g;$s2=~s/ttyS//g; 
	                 $s1<=>$s2;
                    } keys %COMInterfaces)
{  
   my @cols=();
   my $ComDescription=();                        
   my $textBoxName = "[$COMInterfaces{$COM}{'name'}]";
   my $UISelectName = "[$COMInterfaces{$COM}{'name'}]"."_eth";
   my $editEvents = 'onkeydown="veryfiData_OnKeyDown(event)" onfocus="onFocus(event)"';
   my $fileComData = "[LINK_".$COMInterfaces{$COM}{'name'}."]";
   my $checkboxname = "[$COMInterfaces{$COM}{'name'}]"."_status";
   if(!defined($FileData{"[".$COMInterfaces{$COM}{'name'}."]"}))
   {
      my $comname = $COMInterfaces{$COM}{'name'};
      $comname=~s/\d{1,2}//;
      foreach my $comparam (keys %{$defValues{"[".$comname."]"}})
      {
         my $paramname = $defValues{"[".$comname."]"}{$comparam}{'Param'};
         my $value = $defValues{"[".$comname."]"}{$comparam}{'DefValue'};
         $FileData{"[".$COMInterfaces{$COM}{'name'}."]"}{$paramname} =$value;			         
      }   
   }
   if(defined($FileData{$fileComData}))
   {
       $ComDescription=$ComDescription.$FileData{'['.$COMInterfaces{$COM}{'name'}.']'}{'COM_NAME'};
       $ComDescription=~s/"//g;
       push (@cols,html_escape($COMInterfaces{$COM}{'name'})." (".$ComDescription.")");
       push (@cols,ui_select($UISelectName,$FileData{$fileComData}{'eth'},[@EthernetInterfaces],1,0));
       push (@cols,ui_textbox($textBoxName."_port",$FileData{$fileComData}{'port'},20,0,5,"id=".'"'.$COMInterfaces{$COM}{'name'}.'" '.$editEvents));
       push (@cols,ui_textbox($textBoxName."_timeout",$FileData{$fileComData}{'timeout'},10,0,5,"id=".'"'.$COMInterfaces{$COM}{'name'}.'" '.$editEvents));          
       push (@cols,ui_button('Показать',"button",0,"onclick=\"ShowHideDitales(event,'param_$COMInterfaces{$COM}{'name'}')\""));        
       push (@cols,ui_textbox($textBoxName."_porterr","",50,0,120,"id=".'"'.$COMInterfaces{$COM}{'name'}.'" '.$editEvents));
       print  ui_checked_columns_row(\@cols,undef,$checkboxname,undef,$FileData{$fileComData}{'status'});
       print "<tr><td></td><td colspan=\"4\">";
       print "<div id=\"param_$COMInterfaces{$COM}{'name'}\" style=\"display:none\">";
       print &ui_columns_start(["Параметр","Значение"],100,0);
       my %com_params=%{$defValues{'[ttyS]'}};
       foreach my $if_param (sort {$com_params{$a}{'Order'}<=>$com_params{$b}{'Order'}} keys %com_params)
       {
         my $control=();
         given ($com_params{$if_param}{'Type'})
         {
          when ("ComboBox") 
          {        
           	my @values = split(/\,/,$com_params{$if_param}{'Values'});
            my $value=$FileData{'['.$COMInterfaces{$COM}{'name'}.']'}{$com_params{$if_param}{'Param'}};
    	    $control = ui_select("[$COMInterfaces{$COM}{'name'}]".$if_param,[$value],[@values],1,0);
          }       
          when ("EditBox") 
          {
            my $value=$FileData{'['.$COMInterfaces{$COM}{'name'}.']'}{$com_params{$if_param}{'Param'}};
            $value=~s/"//g;
            $control = ui_textbox("[$COMInterfaces{$COM}{'name'}]".$if_param,$value,50,0,100,0,"");
          }
         }
       	
       	print ui_columns_row([$text{$com_params{$if_param}{'Caption'}},$control]);
       }     
       print &ui_columns_end();
       print "</div>";        
       print "</td></tr>";
   }else
   { 
        push (@cols,html_escape($COMInterfaces{$COM}{'name'})." (".$ComDescription.")");
        push (@cols,       ui_select($UISelectName,$EthernetInterfaces[0][0],[@EthernetInterfaces],1,0));
        push (@cols,       ui_textbox($textBoxName."_port","1025",20,0,5,"id=".'"'.$COMInterfaces{$COM}{'name'}.'" '.$editEvents));
        push (@cols,       ui_textbox($textBoxName."_timeout","1",10,0,9,"id=".'"'.$COMInterfaces{$COM}{'name'}.'" '.$editEvents));          
        push (@cols,ui_button('Показать',"button",0,"onclick=\"ShowHideDitales(event,'param_$COMInterfaces{$COM}{'name'}')\""));        
        push (@cols,       ui_textbox($textBoxName."_porterr","",50,0,120,"id=".'"'.$COMInterfaces{$COM}{'name'}.'" '.$editEvents));
        print  ui_checked_columns_row(\@cols,undef,$checkboxname);
       print "<tr><td></td><td colspan=\"4\">";
       print "<div id=\"param_$COMInterfaces{$COM}{'name'}\" style=\"display:none\">";
       print &ui_columns_start(["Параметр","Значение"],100,0);
       my %com_params=%{$defValues{'[ttyS]'}};
       foreach my $if_param (sort {$com_params{$a}{'Order'}<=>$com_params{$b}{'Order'}} keys %com_params)
       {
         my $control=();
         given ($com_params{$if_param}{'Type'})
         {
          when ("ComboBox") 
          {        
           	my @values = split(/\,/,$com_params{$if_param}{'Values'});
            my $value=$com_params{$if_param}{'DefValue'};
    	    $control = ui_select("[$COMInterfaces{$COM}{'name'}]".$if_param,[$value],[@values],1,0);
          }       
          when ("EditBox") 
          {
             my $value=$com_params{$if_param}{'DefValue'};;
                         $value=~s/"//g;
            $control = ui_textbox("[$COMInterfaces{$COM}{'name'}]".$if_param,$value,50,0,100,0,"");
          }
         }      	
       	print ui_columns_row([$text{$com_params{$if_param}{'Caption'}},$control]);
       }     
       print &ui_columns_end();
       print "</div>";        
       print "</td></tr>";
   }
  $i++;
}
print &ui_columns_end(); 
print ui_submit($text{'SubmitButton'},$text{'SubmitButton'},0,'onclick="veryfiData_onSubmit(event)"');
print '<p><b>*Таймаут</b> - период времени, по истечении которого принудительно разывается соединение при отсутсвии активности на  канале данных. Если значение таймаута равно 0, то принудительного разрыва соединения не производится. </p>';
print "<p><b>Примечание: </b>При применении настроек все текущие соединения будут разорваны</p>";
};
