#!/usr/bin/perl
require 'parse_file-lib.pl';
require '../waitbox.pl';
use Switch;
use Version;
init_config();
our $VERSION= Perl::Version->new('1.1.3');
our $MUS_VERSION=Perl::Version->new(`dpkg -p mus |grep -e "Version:[ ]"|sed -r "s/Version:\\s+//g"`);

sub GetSectionsSortedByOrder()
{
	my %KrugSettings = LoadKrugSettings();
	my $path         = $KrugSettings{'GSW_GUICFG'} . "IP2RS/IP2RSCL.sect";
	my %FileData     = GetIniFileData( $path, "cp866" );
	my %ResData      = ();
	foreach my $section ( sort keys %FileData )
	{
		my $order = $FileData{$section}{'Order'};
		foreach $param ( keys %{ $FileData{$section} } )
		{
			if ( $param =~ /order/ )
			{
				next;
			}
			$ResData{$order}{$param} = $FileData{$section}{$param};
		}
	}
	return %ResData;
}

sub BuildInterface()
{
	my %KrugSettings = LoadKrugSettings();
	my $path = $KrugSettings{'GSW_GUICFG'} . 'IP2RS/' . "IP2RSCLIface.config";
	my %defValues = ParseInterfaceConfig($path);
	$path = $KrugSettings{'GSW_SETTINGS'} . "s2n_act.ini";
    my $res=`cat /gsw/settings/ser2net.conf | grep -c \\#\\"`;
    $res=~s/\n//g;
    if(-e $path)
    {
    $path = $KrugSettings{'GSW_SETTINGS'} . "s2n_act.ini";
    }
	else
    {
     $path = $KrugSettings{'GSW_GUICFG'}."/s2n_act.data";   	
    }	

	my %FileData = GetIniFileData( $path, "cp866" );
   	
	my %SectionData = GetSectionsSortedByOrder();
	foreach my $s ( sort keys %SectionData )
	{
		my $section = '[' . $SectionData{$s}{'Name'} . ']';

		if ( $section =~ /CONNECTION/ )
		{
			next;
		}
		my $flDisabled;
		my %ifaceParams = %{ $defValues{$section} };
		if ( $SectionData{$s}{'required'} == 0 )
		{
			if(!defined($FileData{'['.$SectionData{$s}{'Name'}.']'}{'status'}))
			{
  		     print "<Div id=\"$section\" style=\"display:none\">";
			}
			else
			{
  		     print "<Div id=\"$section\" style=\"display:block\">";				
			} 
			print '<p  style="padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px; "align="center">' 
			  . '<font color="blue"><b>'
			  .  $SectionData{$s}{'Caption'},
			  ui_hidden('status' . $section,$FileData{'['.$SectionData{$s}{'Name'}.']'}{'status'})
			  , '</b></font></p>';
		} else
		{
  		    print "<Div id=\"$section\" style=\"display:block\">";			
			print '<p  style=\"padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;\" align="center">'
			  . '<font color="blue"><b>'
			  . $SectionData{$s}{'Caption'}
			  . '</b></font></p>';
			print ui_hidden( 'status' . $section, 1 );

		}		
		print &ui_columns_start(
			[ $text{'ParamHeader'}, $text{'ValueHeader'}, " " ],
			100, 0 );
		my $ifaceSect = $section;
		%ifaceParams = %{ $defValues{$ifaceSect} };
		for ( my $i = 0 ; $i < scalar( keys %ifaceParams ) ; $i++ )
		{
				my @cols = ();
			foreach my $ifaceParam ( sort keys %ifaceParams )
			{

# при первом старте когда нет никаиких файлов конфигурации
# устанавливаем статус согласно данным из конфигурации интерфейса
				if ( !defined( $FileData{$section}{'status'} ) )
				{
					$FileData{$section}{'status'} =
					  $SectionData{$s}{'required'};
					$flDisabled = $FileData{$section}{'status'};
				} else
				{
					$flDisabled = !$FileData{$section}{'status'};
				}
				if ( $ifaceParams{$ifaceParam}{'Order'} == ( $i + 1 ) )
				{
					my $cfgparam = $ifaceParams{$ifaceParam}{'Param'};
					if ( !defined( $FileData{$section}{$cfgparam} ) )
					{
						$FileData{$section}{$cfgparam} =
						  $ifaceParams{$ifaceParam}{'DefValue'};
					}
					switch ( $ifaceParams{$ifaceParam}{'Type'} )
					{
						case "CheckBox"
						{
							if($MUS_VERSION<$VERSION)
							{
								next;
							}
							my $value   = $FileData{$section}{$cfgparam};
							my $checked=($value eq "off");
							my $control = ui_checkbox( $cfgparam . $section,
								$value,"", $checked, "onclick=\"".$ifaceParams{$ifaceParam}{'OnClick'}."\"", 0 );
							push(
								@cols,
								[
									"<p  style=\"padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;\">"
									  . html_escape(
										$ifaceParams{$ifaceParam}{'Caption'}
									  )
									  . "</p>",
									$control
								]
							);
						}
						case "ComboBox"
						{
							my %comports = undef;
							my @tmpvalues = split(/\,/,$ifaceParams{$ifaceParam}{'Values'});
                            my @values;
			                foreach $val (@tmpvalues)
			                {
			  	             push(@values,[split('-',$val)]);
			                }	
						
							my $value   = $FileData{$section}{$cfgparam};
							my $control ;
							if($section=~/\[COMMON\]/)
							{
							 $control=ui_select( $cfgparam . $section,
								[$value], [@values], 1, 0, undef, $flDisabled,"onchange=\"OnCheckBoxClick(event)\""."id='".$cfgparam . $section."'" );								
							}
							else
							{
							 $control=ui_select( $cfgparam . $section,
								[$value], [@values], 1, 0, undef, $flDisabled,"onchange=\"onChangeInterface('".$cfgparam.$section."',"."'IP2$section"."')\"" );
							}
							push(
								@cols,
								[
									"<p  style=\"padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;\">"
									  . html_escape(
										$ifaceParams{$ifaceParam}{'Caption'}
									  )
									  . "</p>",
									$control
								]
							);
						}
						case "EditBox"
						{
							my $value = $FileData{$section}{$cfgparam};

							my $onkeydown = ();
							my $onfocus   = ();
							if (
								defined(
									$ifaceParams{$ifaceParam}{'OnKeyDown'}
								)
							  )
							{
								$onkeydown = 'onkeydown='
								  . $ifaceParams{$ifaceParam}{'OnKeyDown'};
							}
							if (
								defined( $ifaceParams{$ifaceParam}{'OnFocus'} )
							  )
							{
								$onfocus = 'onfocus='
								  . $ifaceParams{$ifaceParam}{'OnFocus'};
							}

							$editEvents = $onkeydown . $onfocus;
							my $control = ui_textbox(
								$cfgparam . $section,
								$value,
								50,
								$flDisabled,
								255,
								"id=" . '"'
								  . $cfgparam
								  . $section . '" '
								  . $editEvents
							);
							my $error_ctrl = ui_textbox(
								$cfgparam . $section . "_err",
								0,
								50,
								0,
								100,
								"id=" . '"'
								  . $cfgparam
								  . $section . "_err" . '" '
							);
							push(
								@cols,
								[
									$ifaceParams{$ifaceParam}{'Caption'},
									$control, $error_ctrl
								]
							);
						}
					}
				}
			}
				print ui_columns_row(@cols);
		}
		print &ui_columns_end();
		print '</Div>';
	}
	foreach my $s ( sort keys %SectionData )
	{
		if ( $SectionData{$s}{'Name'} =~ /CONNECTION/ )
		{
			print '<p  style="padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;" align="center">'
			  . '<font color="blue"><b>'
			  . $SectionData{$s}{'Caption'}
			  . '</b></font></p>';
			last;
		}
	}

	my %ComPorts = GetCOMInterfaces();
	$path = $KrugSettings{'GSW_SETTINGS'}."/ser2net.conf";   
	my %IP2RSData = LoadConfig( $path );
    my $res=`cat $path | grep -c \\#\\"`;
    $res=~s/\n//g;
    if($res==0)
    {
     $path = $KrugSettings{'GSW_GUICFG'}."/IP2RS.data";
     %IP2RSData = GetIniFileData( $path, "cp866" );   	
    }	
	my @FileDataKeys = ();
	foreach $connection ( keys %FileData )
	{
		if ( $connection =~ /CONNECTION_\d{1,2}/ )
		{
			$connection =~ s/\[|\]|CONNECTION_//g;
			push( @FileDataKeys, $connection );
		}
	}

	@FileDataKeys = sort { $a <=> $b } @FileDataKeys;

	my $nextconnection = 0;
	if ( -e $KrugSettings{'GSW_GUICFG'} . 'IP2RS/' . "IP2RSCLIface.config" )
	{
		$nextconnection = $FileDataKeys[ scalar(@FileDataKeys) - 1 ] + 1;
	} else
	{
		$nextconnection = 0;
	}
	if(-e "/gsw/ser2net")
	{
      foreach my $s (keys %FileData)
      {		  
		  if($s =~/CONNECTION/)
		  {
            my $flExist=0;
	        foreach my $link ( sort{my $a1=$a;$b1=$b;$a1=~s/\]|\[|LINK_ttyS//g;$b1=~s/\]|\[|LINK_ttyS//g; $a1<=>$b1} keys %IP2RSData )
	        {

        		if ( $link =~ /LINK_(.*)/ )
        		{
         		if(($FileData{$s}{'LocalPort'} eq $IP2RSData{$link}{'port'})  && ($IP2RSData{$link}{'status'}==1))
        		  {
        		  	$flExist=1;
        		  	last;        		  	
        		  }	
        		}	        	
	        }
	        if($flExist==0)
	        {
	        	delete $FileData{$s};

	        }		    			  	
		  }      	
      }

	foreach my $link ( sort{my $a1=$a;$b1=$b;$a1=~s/\]|\[|LINK_ttyS//g;$b1=~s/\]|\[|LINK_ttyS//g; $a1<=>$b1} keys %IP2RSData )
	{
		my @cols = ();
		if ( $link =~ /LINK_(.*)/ )
		{
			if($IP2RSData{$link}{'status'}==0)
			{
				next;
			}
			my $localport = $IP2RSData{$link}{'port'};
			my $flExist=0;
			my $existConnection=();
			foreach my $s (keys %FileData)
			{
			  if($s =~/CONNECTION_/)
			  {
                if(($FileData{$s}{'LocalPort'} eq $localport) && ($IP2RSData{$link}{'status'}==1))
			  	{
			  		$flExist=1;
			  		$existConnection=$s;
			  		last;
			  	}
			  }	
			}
			$nextconnection++;			
			if($flExist==0)
			{

				$FileData{ '[CONNECTION' . '_'
									  . $nextconnection
									  . ']' }{'LocalPort'} = $localport;
				$_=$link;
				if(/LINK_(ttyS\d{1,5})/)
				{
	
				$FileData{ '[CONNECTION' . '_'
									  . $nextconnection
									  . ']' }{"COM_NAME"}=$IP2RSData{"[$1]"}{'COM_NAME'};	
				}
			}
			else
			{
					            $FileData{ 
									  $existConnection
									  }{'status'}=1;
				$_=$link;
				if(/LINK_(ttyS\d{1,5})/)
				{
				
				$FileData{ $existConnection }{"COM_NAME"}=$IP2RSData{"[$1]"}{'COM_NAME'};
				}	
			}
		}
	}
	}
	$nextconnection++;
	my $mmksFilename = "/gsw/module";
	if ( -e $mmksFilename )
	{
		my $flMmksexist = 0;
		foreach my $s ( keys %FileData )
		{
			if ( $FileData{$s}{'LocalPort'} eq "2404" )
			{
				$Mmksexist = 1;
				$FileData{$s}{"status"}=1;
				$FileData{$s}{"COM_NAME"}="ТМ-канал";
				last;
			}
		}
		if ( $Mmksexist == 0 )
		{
			$FileData{ '[CONNECTION_' . $nextconnection . ']' }{'LocalPort'} =
			  "2404";
			$FileData{ '[CONNECTION_' . $nextconnection . ']' }{'RemotePort'} =
			  "2100";
			$FileData{ '[CONNECTION_' . $nextconnection . ']' }{'status'} = "0";
			$FileData{ '[CONNECTION_' . $nextconnection . ']' }{'COM_NAME'} = "ТМ-канал";
		}
	} else
	{
		foreach my $s ( keys %FileData )
		{
			if ( $FileData{$s}{'LocalPort'} eq "2404" )
			{
				delete $FileData{$s};
				last;
			}
		}

	}
	$nextconnection++;
	my $nameSrvExist=0;
	foreach my $s ( keys %FileData )
	{
		if ( $FileData{$s}{'LocalPort'} eq "65535" )
		{
			$nameSrvExist = 1;
			$FileData{$s}{"status"}=1;
			$FileData{$s}{"COM_NAME"}="Сервер разрешения имён";
			last;
		}
	}
	if ( $nameSrvExist == 0 )
	{
		$FileData{ '[CONNECTION_' . $nextconnection . ']' }{'LocalPort'} =
		  "65535";
		$FileData{ '[CONNECTION_' . $nextconnection . ']' }{'RemotePort'} =
		  "10000";
		$FileData{ '[CONNECTION_' . $nextconnection . ']' }{'status'} = "0";
		$FileData{ '[CONNECTION_' . $nextconnection . ']' }{'COM_NAME'} = "Сервер разрешения имён";
	}
	
	print &ui_columns_start(
		[
			"",
			"Номер локального порта",
			"Номер удалённого порта", "  "
		],
		100, 0
	);

	foreach $section ( sort{$a1=$a;$b1=$b;$a1=~s/\]|\[|CONNECTION_//g;$b1=~s/\]|\[|CONNECTION_//g;$a1<=>$b1} keys %FileData )
	{
		if ( $section =~ /CONNECTION_\d{1,2}/ )
		{
			my $conNum = $section;
			$conNum =~ s/\[CONNECTION_//g;
			chop $conNum;
			$conNum = $conNum - 1;
			my $value            = $FileData{$section}{'LocalPort'};
			$FileData{$section}{'COM_NAME'}=~s/"//g;
			my $LocalPortcontrol = $value . ' ('
			  . $FileData{$section}{'COM_NAME'} . ')';
			  
			$value = $FileData{$section}{'RemotePort'};
			
			$editEvents =
			  'onkeydown="OnKeyDown(event)"' . ' onfocus="onFocus(event)"';
			my $RemotePortcontrol = ui_textbox( 'RemotePort' . $section,
				$value, 50, 0, 50,
				"id=" . '"' . 'RemotePort' . $section . '" ' . $editEvents );
			my $error_ctrl = ui_textbox( $cfgparam . $section . "_err",
				0, 50, 0, 100,
				"id=" . '"' . 'RemotePort' . $section . "_err" . '" ' );
			print ui_hidden( 'LocalPort' . $section,
				$FileData{$section}{'LocalPort'} );
			print ui_checked_columns_row(
				[ $LocalPortcontrol, $RemotePortcontrol, $error_ctrl ],
				undef, 'status' . $section,
				1, $FileData{$section}{'status'}
			);
		}
	}
	print &ui_columns_end();

	
	print '<p align="center">' . ui_submit("Применить") . '</p>';

}

sub RestoreDefaults()
{
	my ( $defaults, $fileData ) = @_
	  ; #Р·РЅР°С‡РµРЅРёСЏ РїРѕ СѓРјРѕР»С‡Р°РЅРёСЋ
	my %defvalues = %$defaults;
	my %FileData  = %$fileData;
	foreach my $sect ( keys %defvalues )
	{
		foreach my $param ( keys %{ $defvalues{$sect} } )
		{
			if ( !defined( $FileData{$sect}{$param} ) )
			{
				$FileData{$sect}{$param} =
				  $defvalues{$sect}{$param}{'DefValue'};
			}
		}
	}
	return %FileData;
}

my $script = "<script language=javascript src='../WaitBox.js'> </script>"."\n".
             "<script language=javascript src='validate.js'> </script>" . "\n".
             '<meta http-equiv="Content-Type" content="text/html"; charset="utf8">';

if($MUS_VERSION<$VERSION)
{
print ui_print_header( undef, $text{'IP2RS_title'}, undef, undef, 1, 1, undef,
	undef, $script, 'onload="hideErors(event);onChangeInterface(\'Type[CHANNEL_MAIN]\',\'IP2[CHANNEL_MAIN]\');onChangeInterface(\'Type[CHANNEL_REZ]\',\'IP2[CHANNEL_REZ]\');"');	
}
else
{
print ui_print_header( undef, $text{'IP2RS_title'}, undef, undef, 1, 1, undef,
	undef, $script, 'onload="init();hideErors(event)"');	
}            
ShowWaitBox("Выполняется сохранение настроек...","none");
print  '<div id="main_div" style="display:block;">';
print ui_form_start( 'SaveData.cgi', 'post',, 0, 'onSubmit="onSubmit(event)"' );
BuildInterface();
print ui_form_end();
print '</div>';
