#!/usr/bin/perl
use WebminCore;
init_config();
require "./tools.pl";
my $script = "<script language=javascript src='ipsec.js'> </script>"."\n".'<meta http-equiv="Content-Type" content="text/html"; charset="utf8">';
print ui_print_header(undef,$text{'IPSEC_title'},undef,undef,1,1,undef,undef,$script);
my %Settings=LoadKrugSettings();

my $filename=$Settings{'ETC'}.'ipsec.secrets';
my $ipsecfile=$Settings{'GSW_ETC'}.'rc.d/init.d/ipsec';
if (!(-e $ipsecfile))
{	
print<<EOF
<p align ="center">
<font color="red">
  <b>ВНИМАНИЕ</b>: Работа данного модуля невозможна.Текущая версия образа не поддерживает данный функционал.
</font> 
<p>
EOF
;
exit 0;	
}
my %data=LoadConfig();
my %networkIfaces=GetNetworkIfaces();

my @ifaces;
foreach $iface (sort keys %networkIfaces)
{
  if($iface=~/lo/)
  {
  	next;
  }
  push(@ifaces,"$iface($networkIfaces{$iface})");
}
print ui_form_start("submit.cgi","post");
print "<table width=\"100%\">";
print "  <tr>";
print "   <td>";
print "Ключевое слово по умолчанию".ui_textbox('edDefaultPassword',$data{'defPassword'}),'<br>';
print ui_checkbox("chkDisableConnections",1,"Запретить нешифрованные соединения",$data{'disableConnections'}),'<p></p>';
print "   </td>";
print "   <td>";
print "<p align=\"center\"><b>Доступные сетевые интерфейсы:<b></p>";
print ui_columns_start(["Сетевой интерфейс","IP-адрес"]);
foreach $iface (sort keys %networkIfaces)
{
  if($iface=~/lo/)
  {
  	next;
  }
print ui_columns_row([$iface,$networkIfaces{$iface}]);  
}
print ui_columns_end();
print "     </table>";
print "   </td>";
print "</tr>";
print "</table>";
delete $data{'disableConnections'};
delete $data{'defPassword'};

print ui_columns_start(["Локальный IP-адрес","IP-адрес сервера","Ключевое слово",""],undef,0,["id=Parametr_table"]);
foreach my $connection (sort {my $a1=$a;$b1=$b; $a1=~s/connection//g;$b1=~s/connection//g;($a1+0)<=>($b1+0)}keys %data)
{
if($connection=~/connection/)
{	
my $ip_name=$connection;
$ip_name=~s/\.//g;
$ip_name='Server'.$ip_name;
my $keyword_name=$connection;
$keyword_name=~s/\.//g;
$keyword_name='keyword'.$keyword_name;
my $localserver_name=$connection;
$localserver_name=~s/\.//g;
$localserver_name='LocalServer'.$localserver_name;
my $defaultroute_name=$connection;
$defaultroute_name=~s/\.//g;
$defaultroute_name='DefaultRoute'.$defaultroute_name;
my $anyip_name=$connection;
$anyip_name=~s/\.//g;
$anyip_name='AnyIP'.$anyip_name;

print ui_columns_row([ui_textbox($localserver_name,$data{$connection}{'left'},0,$data{$connection}{'useDefaultRoute'}==1,0,"id=\"$localserver_name\"")."<br>".
                                ui_checkbox($defaultroute_name,1,'Шлюз по умолчанию',$data{$connection}{'useDefaultRoute'}," id=\"$defaultroute_name\" onclick=\"defaultRouteClick('$defaultroute_name','$localserver_name','$keyword_name')\" "),
                      ui_textbox($ip_name,$data{$connection}{'right'},0,$data{$connection}{'useAnyIP'}==1,0,"id=\"$ip_name\"")."<br>".
                                ui_checkbox($anyip_name,1,'Любой IP',$data{$connection}{'useAnyIP'}==1," id=\"$anyip_name\" onclick=\"AnyIPClick('$anyip_name','$ip_name','$keyword_name')\" "),
					  ui_textbox($keyword_name,$data{$connection}{'password'},0,($data{$connection}{'useAnyIP'}==1)||($data{$connection}{'useDefaultRoute'}==1),0,"id=\"$keyword_name\"").'<br>',
					  ui_button('Удалить',undef,0,"onclick=removeserver(event,\"$ip_name\")")
                     ]);	
}
}
print ui_columns_end();

print ui_button("Добавить соединение",undef,0,"onclick=\"addServer(event)\"");
print "<p align=\"center\">";
print ui_submit("Применить",undef,0,"onclick=\"validate(event)\"");
#print ui_submit("Применить",undef,0);
print "</p>";
print ui_form_end();


print<<EOF;
<table width="100%">
<tr>
<td><b>ВНИМАНИЕ:</b></td>
<td>
<td>
</td>
</tr>
<tr>
<td></td>
<td><p align="justify"> 
При активации в настройках соединения параметра "Шлюз поумолчанию" и/или "Любой IP" в качестве
ключевого слова возможно использование только параметра "Ключевое слово поумолчанию".
При настройке шифрованного соединения по GPRS-каналу рекомендуется предварительно настроить и  
активировать GPRS-соединение. В этом случае в таблице "доступные сетевые интерфейсы" будет  
доступен текущий IP-адрес, который можно будет указать в качестве локального IP-адреса при настройке
соединения. Если такой подход недопустим, активируйте параметр "Шлюз поумолчанию" </p>
</td>
</tr>
</table>
EOF
