use feature ":5.10";
sub LoadConfig()
{
  my %Settings=LoadKrugSettings();
  my $filename=$Settings{'ETC'}.'ipsec.secrets';
  my $out=`iconv -f cp866 -t utf-8 $filename -o /tmp/ipsec.secrets`;
  my @output = `cat /tmp/ipsec.secrets`;
  my %secrets_data = ();
  foreach $s (@output)
  {
    chomp ($s);
    if($s=~/#/) #удаляем комментарии
    {
		$s=~s/#.*//g;    	
    }
    $_ = $s;
    if(/^\:\sPSK\s"(.*)"$/)
    {
     $secrets_data{'defpasswd'}="$1";
    }
    else
    {
      if(/^(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})\s(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})\s+:\s+PSK\s+"(.*)"$/)
      {
        my $tmp = "$3";
        $secrets_data{"$1$2"}=$tmp;
      }
    }
  }
  $filename=$Settings{'ETC'}.'ipsec.conf';
  $out=`iconv -f cp866 -t utf-8 $filename -o /tmp/ipsec.conf`;
  @output = `cat /tmp/ipsec.conf`;
  my $currentconn=();
  my %data=();
  foreach $str (@output)
  {
     if($str=~/#/) #удаляем комментарии
    {
		$str=~s/#.*//g;    	
    } 
  	if($str=~/conn\s(connection\d{1,5})/)
  	{
  		$currentconn="$1";
  	}
  	else
  	{
  	  if ($str=~/\s+(.*)=(.*)/)
      {
  		  $data{$currentconn}{"$1"}="$2";  	
  	  }  		
  	} 	
  }
  foreach $connection (keys %data)
  {
  	my $left=$data{$connection}{'left'};
  	my $right=$data{$connection}{'right'};
  	if($left=~/%defaultroute/)
  	{
  	 $data{$connection}{'useDefaultRoute'}=1;
  	 $data{'defPassword'}=$secrets_data{'defpasswd'};
  	 $data{$connection}{'left'}="";	
  	}
  	if($right=~/%any/)
  	{
  	 $data{$connection}{'useAnyIP'}=1;	  		
  	 $data{'defPassword'}=$secrets_data{'defpasswd'};
  	 $data{$connection}{'right'}="";	
  	} 
  	if(($left=~/\d{1,3}.\d{1,3}.\d{1,3}.\d{1,3}/) && ($right=~/\d{1,3}.\d{1,3}.\d{1,3}.\d{1,3}/))
  	{
  	 $data{$connection}{'password'}=$secrets_data{"$left$right"};	  		  		
  	}
  }
  $filename=$Settings{'ETC'}.'ipsec-tools.conf';
  $out=`iconv -f cp866 -t utf-8 $filename -o /tmp/ipsec-tools.conf`;
  @output = `cat /tmp/ipsec-tools.conf`; 
  my $disableconnectfile=$Settings{'GSW_ETC'}."fw_req";
  if(-e $disableconnectfile)
  {
  	$data{'disableConnections'}=1;
  } 
  else
  {
  	$data{'disableConnections'}=0;  	
  }
  return %data; 	
} 
sub LoadKrugSettings()
{
  my @output = `cat /gsw/etc/krug.env`;
  my %data = ();
  foreach $s (@output)
  {
    chomp ($s);
    $_ = $s;
    if(/(\.*)\=(\.*)/)
    {
        my $tmp = "$'";
        $data{"$`"}=$tmp; 
    }
  }
  return %data;
}



sub GetNetworkIfaces()
{
  my $output=`ifconfig`;
  my $curEth;
  my @eth;
  my @ip;
  my %res;
  	while($output=~/(eth|ppp)(\d{1,3})|(lo)/g)
  	{
  		push (@eth,"$1$2$3");
  	}
  	while($output=~/inet addr:(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})/g)
  	{
  		push (@ip,"$1");
  	}
  	for($i=0;$i<scalar(@eth);$i++)
  	{
  		$res{$eth[$i]}=$ip[$i];
  	}	
    return %res;  
} 	
sub GetUseDefaultPassword()
{
	(my $Data)= @_;
	my $res=0;
	foreach $p (keys %$Data)
	{
		if($p=~/(DefaultRouteconnection\d{1,12})|(DefaultRoute_new\d{1,5})/)
		{
			$res=1;
			last;
		}
		else
		{ 
		   if($p=~/(AnyIPconnection\d{1,12})|(AnyIP_new\d{1,5})/)
		   {
			$res=1;
			last;
		   }
		}
	}
	return $res;
}
1;