#!/usr/bin/perl
use feature ":5.10";
require './parse_file-lib.pl';
require '../waitbox.pl';
sub GetConnectedSensors()
{
	my %settings = LoadKrugSettings();
	my $drv=$settings{'GSW'}.'dsens';
	my $output=`$drv -s`;
	my @tmp=split(/\s{1,}/,$output);
	my $type;
	my %data=();
	my $j=1;
	for (my $i=0;$i<scalar(@tmp);$i++)
	{
		if($tmp[$i]=~/\[(\S+)\]/)
		{
		 $type=$tmp[$i];
		 $j=1;
#		 $type=~s/\[|\]//g;
		}
		else
		{
	
		   $_=$tmp[$i];

		   if(/(\S+)\.(\S+)/)
		   {
		    $data{$type}{$j}="$1".'.'."$2";
		    $j++;
		   }else
		   {
		   	$data{$type}{$j}=$tmp[$i];
		   	 $j++;
		   }
		}
	}
	undef @tmp;
	return %data;
}
sub GetSensorTypes()
{
	my %settings = LoadKrugSettings();
	my $file=$settings{'GSW_GUICFG'}.'onewire/iface.config';
	my %data=GetIniFileData($file);
	return %data;	
}

my %settings = LoadKrugSettings();
my $onewireFile = $settings{'GSW_SETTINGS'}.'onewire.ini';
my %connectedSensors=GetConnectedSensors();
my %data=();
if(-e $onewireFile)
{
	%data=GetIniFileData($onewireFile);
	if(scalar(keys %connectedSensors)==0)
	{
     redirect('./cfgnotset.cgi');        		
	}
	else
	{
      my $script ="<script language=javascript src='../WaitBox.js'> </script>"."\n".
    "<script language=javascript src='./validate.js'> </script>" . "\n"
  . '<meta http-equiv="Content-Type" content="text/html"; charset="utf8">';
      print ui_print_header(undef,$text{'ONEWIRE_title'},"",undef,undef,1,undef,undef,$script,undef);
      print ui_form_start('SaveData.cgi'); 
	  if(scalar(keys %connectedSensors)==0)
	  {
			print '<p align="center">';
			print '<font color="red"><b>Подключенных датчиков не обнаружено<b></font>';
			print '</p>';				  
	  }
	}
}
else
{
   # %connectedSensors=GetConnectedSensors();
    if(scalar(keys %connectedSensors)==0)
    {
      redirect('./cfgnotset.cgi');
    } else
    {
           my $script =
    "<script language=javascript src='./validate.js'> </script>" . "\n"
  . '<meta http-equiv="Content-Type" content="text/html"; charset="utf8">';
      print ui_print_header(undef,$text{'ONEWIRE_title'},"",undef,undef,1,undef,undef,$script,undef);
      print ui_form_start('SaveData.cgi'); 
    }  	
}  
ShowWaitBox("Выполняется обновление информации...","none");
print  '<div id="main_div" style="display:block;">';        
#отображаем привязок датчиков к номерам платы
my %sensorTypes=GetSensorTypes();
print ui_columns_start( [ 'Тип датчика', 'Номер платы'],"50");
foreach $type (sort{$a1=$sensorTypes{$a}{'order'};$b1=$sensorTypes{$b}{'order'};$a1<=>$b1} keys %sensorTypes)
{
	my $boardNumbers=$sensorTypes{$type}{'BoardNumbers'};
	my @boardNumbersArr=();
	for($i=200;$i<=255;$i++)
	{
		push (@boardNumbersArr,[$i,$i]);
	}
	my $nplt=$sensorTypes{$type}{'NPLT'};
	if(defined($data{$type}{'NPLT'}))
	{
		$nplt=$data{$type}{'NPLT'};
	}
	else
	{
	$data{$type}{'NPLT'}= $nplt;
  }
	print ui_columns_row([
	                      $sensorTypes{$type}{'Caption'},
	                      ui_select($type.'_boardnum',$data{$type}{'NPLT'},[@boardNumbersArr],1,0)
	                      ]
			);
}
print ui_columns_end();
#формирование таблиц датчиков
foreach $s (keys %connectedSensors)
{
 foreach  $p(sort {$a<=>$b}keys %{$connectedSensors{$s}})
 {
   my $value=$connectedSensors{$s}{$p};
   my $fl_present=0;
   my $p1;
   foreach $p1 (keys %{$data{$s}})
   {
        my $value=$connectedSensors{$s}{$p};
      if($data{$s}{$p1}=~/$value/)
       {
         $fl_present=1;
         last;
       }
   }
   if($fl_present==1)
    {
      next;
    }
   else
   {  
   	  my %tmp=%{$data{$s}};
   	  my $newch=GetUniqueChNymber(\%tmp);
      $data{$s}{$newch}=$connectedSensors{$s}{$p}."new";
   }
 }
}
foreach $type (sort{$a1=$sensorTypes{$a}{'order'};$b1=$sensorTypes{$b}{'order'};$a1<=>$b1} keys %sensorTypes)
{
  if(defined($data{$type}))
  { 	
  	if((scalar(keys %{$data{$type}})-1)==0)
  	{
    next;
    }
    print '<p align="left"><b><font color="blue">'.$sensorTypes{$type}{'Caption'}.'</font></b></p>';
  	given($type)
  	{
  	when(/RELS/)
  	{
  		print ui_columns_start(["","Номер канала","Идентификатор","Тип","Описание","Статус"],"80");
  		foreach $sens (sort keys %{$data{$type}})
  		{
  			if($sens=~/comment|NPLT/)
  			{
  				next;
  			}
  			my @cols=();
  			my $rel_type=""; #тип реле
  			my $groupID="";
  			my $ID="";
  			my $editEvents = 'onkeydown="OnKeyDown(event)"';
  			my $comment=$data{$type}{'comment'.$sens};
            my $fl_old = IsSensorInConfig ($sens,$type, \%data);  			
            $_=$data{$type}{$sens};  			
  			if(/(\S+)\.(\S+)\,(\d{0,1})$/)
  			{
  				$rel_type="$3";
  				$ID="$2";
  				$groupID="$1";
  			}else
  			{
	          if(/(\S+)\.(\S+)$/)
	          {
  				$rel_type=0;
  				$ID="$2";
  				$groupID="$1";
          
	          }
           }
  			my $connected=();
  			my $flConnected=isConnected ($sens, $type, \%connectedSensors, \%data);        
            if($flConnected==1)
  			{
  				$connected='<img src="./connect.png">';
  			}
  			else
  			{
  				$connected='<img src="./disconnect.png">';  				
  			}
  			if($fl_old==1)
  			{
  			push(@cols,[ ui_checkbox($type.'_'.$sens.'_flSave',1,"",$fl_old,undef,0),
  			             ui_textbox($type.'_'.$sens.'_Chanel',$sens,1,0,3,$editEvents),
  			             $groupID.'.'.$ID.ui_hidden($type.'_'.$sens.'_ID',$ID).ui_hidden($type.'_'.$sens.'_GroupID',$groupID),
  			             ui_select($type.'_'.$sens.'_type',$rel_type,[[1,"обычное"],[2,"бистабильное"]]),
  			             ui_textbox($type.'_'.$sens.'_Comment',$comment,30,0,100), 			                			           
  			             $connected
  			           ] 			
  			    );
  			}else
  			{
  			push(@cols,[ ui_checkbox($type.'_'.$sens.'_flSave',1,"",$fl_old,undef,0),
  			             ui_textbox($type.'_'.$sens.'_Chanel',$sens,1,0,3,$editEvents),
  			             $groupID.'.'.$ID.ui_hidden($type.'_'.$sens.'_ID',$ID).ui_hidden($type.'_'.$sens.'_GroupID',$groupID),
  			             ui_select($type.'_'.$sens.'_type',$rel_type,[[1,"обычное"],[2,"бистабильное"]]),
  			             ui_textbox($type.'_'.$sens.'_Comment',$comment,30,0,100),
  			             $connected.'<img src="./new.gif">'  			                			           		               			           
  			           ] 			
  			    );  				
  			}
  			print ui_columns_row(@cols);
  		}  		
  	}
  	when(/VIRTSERVS/)
  	{
   		print ui_columns_start(["","Номер канала","Идентификатор","Параметр","Описание","Статус"],"80");
  		foreach $sens (sort keys %{$data{$type}})
  		{
  			if($sens=~/comment|NPLT/)
  			{
  				next;
  			}
  			my @cols=();
  			my $time=""; #Время сброса
  			my $groupID="";
  			my $ID="";
  			my $editEvents = 'onkeydown="OnKeyDown(event)"';
  			my $comment=$data{$type}{'comment'.$sens};
            my $fl_old = IsSensorInConfig ($sens,$type, \%data);		
            $_=$data{$type}{$sens};  			
  			given($data{$type}{$sens})
  			{
  				when(/(\S+)\,(\d{0,4})$/)
  				{
  				$time="$2";
  				$ID="$1";  					
  				}
  				when(/(\S+)\.(\S+)$/)
  				{
  				$time=0;
  				$ID="$1";  					
  				}
  				default
  				{
  				$time=0;
  				$ID=$data{$type}{$sens};	          	  					
  				}
  			}
#  			if(/(\S+)\,(\d{0,4})$/)
#  			{
#  				$time="$2";
#  				$ID="$1";
#  			}else
#  			{
#	          if(/(\S+)\.(\S+)$/)
#	          {
#  				$time=0;
#  				$ID="$1";
#	          }else
#	          {
#  				$time=0;
#  				$ID=$_;	          	
#	          }
#           }
  			my $connected=();
  			my $flConnected=isConnected ($sens, $type, \%connectedSensors, \%data);        
            if($flConnected==1)
  			{
  				$connected='<img src="./connect.png">';
  			}
  			else
  			{
  				$connected='<img src="./disconnect.png">';  				
  			}
  			if($fl_old==1)
  			{
  			push(@cols,[ ui_checkbox($type.'_'.$sens.'_flSave',1,"",$fl_old,undef,0),
  			             ui_textbox($type.'_'.$sens.'_Chanel',$sens,1,0,3,$editEvents),
  			             $ID.ui_hidden($type.'_'.$sens.'_ID',$ID).ui_hidden($type.'_'.$sens.'_GroupID',""),
  			             ui_textbox($type.'_'.$sens.'_time',$time,30,0,2,"onkeydown=\"OnKeyDown(event)\""),
  			             ui_textbox($type.'_'.$sens.'_Comment',$comment,30,0,100), 			                			           
  			             $connected
  			           ] 			
  			    );
  			}else
  			{
  			push(@cols,[ ui_checkbox($type.'_'.$sens.'_flSave',1,"",$fl_old,undef,0),
  			             ui_textbox($type.'_'.$sens.'_Chanel',$sens,1,0,3,$editEvents),
  			             $ID.ui_hidden($type.'_'.$sens.'_ID',$ID).ui_hidden($type.'_'.$sens.'_GroupID',""),
  			             ui_textbox($type.'_'.$sens.'_time',$time,30,0,2,"onkeydown=\"OnKeyDown(event)\""),
  			             ui_textbox($type.'_'.$sens.'_Comment',$comment,30,0,100),
  			             $connected.'<img src="./new.gif">'  			                			           		               			           
  			           ] 			
  			    );  				
  			}
  			print ui_columns_row(@cols);
  		}  		
  		
  	}
  	default
  	{
  		print ui_columns_start(["","Номер канала","Идентификатор","Описание","Статус"],"80");
  		foreach $sens (sort keys %{$data{$type}})
  		{
  			if($sens=~/comment|NPLT/)
  			{
  				next;
  			}
  			my @cols=();
  			my $rel_type=""; #тип реле
  			my $groupID="";
  			my $ID="";
  			my $editEvents = 'onkeydown="OnKeyDown(event)"';
  			my $comment=$data{$type}{'comment'.$sens};
            my $fl_old = IsSensorInConfig ($sens,$type,\%data);  
  			$_=$data{$type}{$sens};
  			if(/(\S+)\.(\S+)\,{0,1}(\d{0,1})$/)
  			{
  				$rel_type="$3";
  				$ID="$2";
  				$groupID="$1";
  			}
  			my $connected=();
  		    my $flConnected=isConnected ($sens, $type, \%connectedSensors, \%data);
  			if($flConnected==1)
  			{
  				$connected='<img src="./connect.png">';
  			}
  			else
  			{
  				$connected='<img src="./disconnect.png">';  				
  			}
			if($fl_old==1)
  			{			
 			push(@cols,[ ui_checkbox($type.'_'.$sens.'_flSave',1,"",$fl_old,undef,0),
  			             ui_textbox($type.'_'.$sens.'_Chanel',$sens,1,0,3,$editEvents),
  			              $groupID.'.'.$ID.ui_hidden($type.'_'.$sens.'_ID',$ID).ui_hidden($type.'_'.$sens.'_GroupID',$groupID),
  			             ui_textbox($type.'_'.$sens.'_Comment',$comment,30,0,100),
  			             $connected  			                			           		               			           
  			           ] 			
  			    );
  			}
  			else
  			{
 			push(@cols,[ ui_checkbox($type.'_'.$sens.'_flSave',1,"",$fl_old,undef,0),
  			             ui_textbox($type.'_'.$sens.'_Chanel',$sens,1,0,3,$editEvents),
  			              $groupID.'.'.$ID.ui_hidden($type.'_'.$sens.'_ID',$ID).ui_hidden($type.'_'.$sens.'_GroupID',$groupID),
  			             ui_textbox($type.'_'.$sens.'_Comment',$comment,30,0,100),
  			             $connected.'<img src="./new.gif">'  			                			           		               			           
  			           ] 			
  			    );
  				
  			}
  			print ui_columns_row(@cols);
  		}
  		  		
  	} 
  	}
  	print ui_columns_end(); 	
  }	
}
print ui_button('Обновить',undef,0,'onClick="Refresh()"');
print ui_submit('Применить','Apply',0,'onclick="onSubmit(event)"');
print <<EOF;
<p>
<table width="50%">
  <tr>
    <td width="15%">
      <b>Примечание:</b>
    </td>
    <td width="70%">  
      <img src="./new.gif"> - Датчик подключен к контроллеру, но отсутствует в конфигурации драйвера
    </td>
  </tr>
</table>
</p>
EOF
print '</div>';
print ui_form_end();


sub isConnected
{
	my $sens             = shift;
	my $type             = shift;
	my $connectedSensors = shift;
	my $data             = shift;
    my $flConnected=0;
	foreach $p1 ( keys %{ $connectedSensors->{$type} } )
	{
		my $value = $connectedSensors->{$type}{$p1};
		if ( $data->{$type}{$sens} =~ /$value/ )
		{
			$flConnected = 1;
			last;
		}
	}
	return ($flConnected);
}

sub IsSensorInConfig
{
	my $sens = shift;
	my $type= shift;
	my $data = shift;
	$fl_old=0;
	if ( $data->{$type}{$sens} =~ /new/ )
	{
		$fl_old = 0;
		$data->{$type}{$sens} =~ s/new//g;
	}
	else
	{
		$fl_old=1;
	}

	return $fl_old;
}
sub GetUniqueChNymber()
{
	my ($data)=@_;
    my $max = 0; 
    foreach $temp (keys %$data) 
    {   	 
      		if($temp=~/comment|NPLT/)
  			{
  				next;
  			}
      
      $max = $temp if $temp > $max; 
    }
    $max++;

    return $max;
}
