#!/usr/bin/perl
use WebminCore;
init_config();
require "./tools.pl";
use CGI qw(:standart);
use CGI::Carp qw(fatalsToBrowser);
my %params = CGI::Vars();
my $script = "<script language=javascript src='find_abonents.js'> </script>"."\n".'<meta http-equiv="Content-Type" content="text/html"; charset="utf8">';
print ui_print_header(undef,undef,undef,undef,1,1,undef,undef,$script);
BuildInterface($params{'plc_number'},$params{'get_from_file'});
sub BuildInterface()
{
 (my $plc,my $get_from_file)=@_;
 my $Data;
 if($get_from_file=='true')
 {
  $Data=LoadConfig();
 }
 my @new_abonents=find_abonents($plc,$params{'port_plc'},$params{"timeout"},$params{'PAN_ID'});
 for($i=0;$i<scalar(@new_abonents);$i++)
 {
	if($new_abonents[$i]=~/(Error: )(.*)/)
	{
		print "<p align=\"center\"><font color=\"red\"><b>$2</b></font></p>";
		last;
	}
 }
 my %plcSettings=%{$Data->{"[PLC_$plc]"}};
 my %abonentsSettings=%{$Data->{"[abonents_$plc]"}};
 
 my $selectall=ui_button("Выделить всё","selectall",0,"onclick=\"select_all($plc,true)\"");
 my $unselectall=ui_button("Сбросить всё","unselectall",0,"onclick=\"select_all($plc,false)\""); 
 my $abonents_table=ui_columns_start(["№","MAC адрес абонента","Статус"],"40");
 my $i=1;
 foreach $abonent (sort {$a<=>$b}keys %abonentsSettings)
 {
 	my $fl_connected=-1;
 	for($j=0;$j<scalar(@new_abonents);$j++)
 	{
 	  	$new_abonents[$j]=~s/(\n)|(\r)//g;
 	  	if($new_abonents[$j] eq $abonentsSettings{$abonent})
 	  	{
 	  	  $fl_connected=1;
 	  	  splice(@new_abonents,$j,1);
 	  	  last;	
 	  	}
 	  	
 	}
 	my $image;
 	if($fl_connected==1)
 	{
 		$image="./connect.png";
 	}
 	else
 	{
 		$image="./disconnect.png";		
 	}
 	$abonents_table="<p align=\"center\">".$abonents_table.ui_columns_row([$abonent,
 													ui_checkbox("Mac_addr".$i."_plc".$plc,$abonentsSettings{$abonent},$abonentsSettings{$abonent},1),
 													"<img src=\"$image\"/>", 													
 												   ] 												  
 												  );
 	$i++;
 }
 	for($j=0;$j<scalar(@new_abonents);$j++)
 	{
 	 	 if($new_abonents[$j]=~/(Error: )(.*)/)
 	  	{
 	  		last;
 	  	}
 	
 	$abonents_table="<p align=\"center\">".$abonents_table.ui_columns_row([$i,
 													ui_checkbox("Mac_addr".$i."_plc".$plc,$new_abonents[$j],$new_abonents[$j],1),
 													"<img src=\"./connect.png\"/>", 													
 												   ] 												  
 												  );
 	$i++;
	  	
 	}
 
 $abonents_table=$abonents_table.ui_columns_end()."</p>";
 if((scalar(keys %abonentsSettings)==0)&&(scalar(@new_abonents)==0))
 {
   undef $abonents_table;
   undef $selectall;
   undef $unselectall;	
 }
 print <<EOF
 $abonents_table
 <p align="center">
 <table>
  <tr>
    <td>
      $selectall
    </td>
    <td>
     $unselectall
    </td>
  </tr>
 </table>
 </p>
EOF
;
}

sub find_abonents()
{
(my $plc,my $port_plc,my $timeout,my $PAN_ID)=@_;
 my @newAbonents=`/gsw/plc -p $port_plc -t $timeout -i $PAN_ID|iconv -f cp866 -t utf-8`;
 return @newAbonents;	
}