#!/usr/bin/perl
use WebminCore;
init_config();
require "./tools.pl";
my $script = "<script language=javascript src='./find_abonents.js'> </script>"."\n".'<meta http-equiv="Content-Type" content="text/html"; charset="utf8">'.'<link href="./bar.css" type="text/css" rel="stylesheet">';
print ui_print_header(undef,$text{'PLC_NETWORK_SETUP_title'},undef,undef,1,1,undef,undef,$script);
my %Settings=LoadKrugSettings();
use CGI qw(:standart);
use CGI::Carp qw(fatalsToBrowser);
my %params = CGI::Vars();
@tabs = ( );
my $Data=LoadConfig();

push(@tabs, [ "PLC_1", "Встроенный PLC-модем /PLC-модем 1", "index.cgi?mode=PLC_1" ]);
push(@tabs, [ "PLC_2", "PLC-модем 2", "index.cgi?mode=PLC_2" ]);
push(@tabs, [ "PLC_3", "PLC-модем 3", "index.cgi?mode=PLC_3" ]);
print &ui_tabs_start(\@tabs, "mode", $params{'mode'} || $tabs[0]->[0], 1);
print &ui_tabs_start_tab("mode", "PLC_1");
print ui_form_start('submit.cgi','post',undef);
BuildInterface("1",$Data);
print ui_form_end();
print &ui_tabs_end_tab();

print &ui_tabs_start_tab("mode", "PLC_2");
print ui_form_start('submit.cgi','post',undef);
BuildInterface("2",$Data);
print ui_form_end();
print &ui_tabs_end_tab();

print &ui_tabs_start_tab("mode", "PLC_3");
print ui_form_start('submit.cgi','post',undef);
BuildInterface("3",$Data);
print ui_form_end();
print &ui_tabs_end_tab();
print &ui_tabs_end();

sub BuildInterface()
{
(my $plc,my $Data)=@_;
 my %plcSettings=%{$Data->{"[PLC_$plc]"}};
 my %abonentsSettings=%{$Data->{"[abonents_$plc]"}};
 my $port_plc=ui_textbox("port_plc$plc",$plcSettings{'tty'},30,0,30,"id=\"port_plc$plc\"");
 my $PAN_ID=ui_textbox("PAN_ID$plc",$plcSettings{'PANID'},30,0,30,"id=\"PAN_ID$plc\"");
 my $FindAbonents=ui_button("Поиск абонентов","find_abonents",0,"onclick=\"GetData(event,$plc,true)\"");
 my $applybtn=ui_button("Применить","submitbtn_$plc",0,"id=\"submitbtn_$plc\" onclick=\"_submit_(event,$plc)\"");
 my $plc_ctrl=ui_hidden("plc_num",$plc);
 my $selectall=ui_button("Выделить всё","selectall",0,"onclick=\"select_all($plc,true)\"");
 my $unselectall=ui_button("Сбросить всё","unselectall",0,"onclick=\"select_all($plc,false)\""); 
 my $timeout=ui_select("Timeout_$plc","315",[[315,"5 мин"],[615,"10 мин"],[915,"15 мин"],[1815,"30 мин"]],1,0,0,0,"id=\"Timeout_$plc\" onchange=\"timeoutChange(event)\"");
 my $abonents_table=ui_columns_start(["№","MAC адрес абонента","Статус"],"40");
 my $i=1;
 foreach $abonent (sort {$a<=>$b}keys %abonentsSettings)
 {
 	$abonents_table="<p align=\"center\">".$abonents_table.ui_columns_row([$abonent,
 													ui_checkbox("Mac_addr".$i."_plc".$plc,$abonentsSettings{$abonent},$abonentsSettings{$abonent},1),
 													"<img src=\"./unknown.png\"/>", 													
 												   ] 												  
 												  );
   $i++;
 }
 $abonents_table=$abonents_table.ui_columns_end()."</p>";
 if(scalar(keys %abonentsSettings)==0)
 {
 	undef $abonents_table;
 	undef $selectall;
 	undef $unselectall;
 } 
 print <<EOF
 <p align="center">
 <table>
   <tr>
    <td>
     Порт PLC-модема: 
    </td>
    <td>
    $port_plc
    </td>
    <td>
    &nbsp&nbspНомер порта ttyS,к которому подключен PLC-модем. Значение задаётся в формате ttyS<номер порта>. <br/> &nbsp&nbsp<b>Пример: ttyS2</b>
    </td>
   </tr>
   <tr>
    <td>
     Идентификатор сети (PAN ID):
    </td>
    <td>
     $PAN_ID
    </td>
    <td>
      &nbsp&nbspИдентификатор сети PLC. Задаётся в виде двухзначного шестнадцатеричного числа.<br/> &nbsp&nbsp<b>  Пример:0x3A</b>
    </td>
   </tr>
   <tr>
    <td>
    Таймаут ожидания подключения абонентов
    </td>
    <td>
     $timeout
    </td>
    <td>
      <div id="timeout_comment_$plc">
      &nbsp&nbspРекомендуемое время поиска абонентов.
      </div>
    </td>
   </tr>

 </table>
 </p>
 <p align="center">
  $FindAbonents 
 </p>
 <div id="progress_bar_$plc" align="center" style="display:none">
 <div id="bar_$plc" class="bar" style="width:300px;background:#003458;height:50px;" align="left">
  <div id="before_$plc" class="before">
  </div> 
  <div id="after_$plc" class="after">
  </div> 
 </div>
 </div>
 <div id="abonents$plc">

 $abonents_table
 <p align="center">
 <table>
  <tr>
    <td>
      $selectall
    </td>
    <td>
     $unselectall
    </td>
  </tr>
 </table>
 </p> 
 </div>
 <p align="center">$applybtn</p>
EOF
;
}





