use feature ":5.10";
use WebminCore;
init_config();

sub LoadKrugSettings()
{
  my @output = `cat /gsw/etc/krug.env`;
  my %data = ();
  foreach $s (@output)
  {
    chomp ($s);
    $_ = $s;
    if(/(\.*)\=(\.*)/)
    {
        my $tmp = "$'";
        $data{"$`"}=$tmp; 
    }
  }
  return %data;
}
sub LoadConfig()
{
	my %settings=LoadKrugSettings();
	my $path=$settings{'GSW_SETTINGS'}."plc.ini";
	if(!(-e $path))
	{
	  $_=`touch $path`;	
	}
	my %Data=GetIniFileData($path);
	return \%Data;	
}
sub GetIniFileData()
{
 my ($filename) = @_;
 my $INIFILE;
 my $section;
 my %Data;
 $out=`iconv -f cp866 -t utf-8 $filename -o /tmp/plc.ini`;
 if ( open( INIFILE, "</tmp/plc.ini") != 0 )
 {
  while (<INIFILE>)
  {
   chomp;
   $_ =~ s/:.*//g;
   if (/\[.+?\]/)
   {
    $section = $_;
    $Data{$section}=undef;    
   }
   if (/(\.*)=(\.*)/)
   {
    my $s = "$`";
    $s =~ s/:.*//g;
    my $s1 = "$'";
    $Data{$section}{$s} = $s1;
   }
  }
  close(INIFILE);
 }
 $out=`rm -f /tmp/plc.ini`;
 return %Data;
}

1;