/*
 * CCgiRequest.cpp
 *
 *  Created on: Mar 31, 2013
 *      Author: root
 */

#include <vector>
#include <string>
#include <vector>
#include <sstream>
#include <stdio.h>
#include "CCgiRequest.h"
#include "deelx.h"

  CCgiRequest::CCgiRequest(string request)
  {
    // TODO Auto-generated constructor stub
    m_request=UriDecode(request);
    Parse();
  }

  CCgiRequest::~CCgiRequest()
  {
    // TODO Auto-generated destructor stub
  }

  void CCgiRequest::Parse()
  {
     static CRegexpT <char> regexp("(.*)=(.*)");
     stringstream ss(m_request);
     string item;
     while(getline(ss,item,'&'))
       {
         MatchResult res = regexp.MatchExact(item.c_str());
         if(res.IsMatched())
           {
             int param_pos_start=res.GetGroupStart(1);
             int param_pos_end=res.GetGroupEnd(1);
             int value_pos_start=res.GetGroupStart(2);
             int value_pos_end=res.GetGroupEnd(2);
             string param=item.substr(param_pos_start,param_pos_end-param_pos_start);
             string val=item.substr(value_pos_start,value_pos_end-value_pos_start);
             m_parametras[param]=val;
           }
       }
  }
  std::string CCgiRequest::UriDecode(const std::string & SRC)
    {
   	    string ret;
   	    char ch;
   	    int i, ii;
   	    for (i=0; i<SRC.length(); i++) {
   	        if (int(SRC[i])==37) {
   	            sscanf(SRC.substr(i+1,2).c_str(), "%x", &ii);
   	            ch=static_cast<char>(ii);
   	            ret+=ch;
   	            i=i+2;
   	        } else {
   	            ret+=SRC[i];
   	        }
   	    }
   	    return (ret);
    }
