#include <stdio.h>
#include <string.h>

#include <iconv.h>

#include "CEncodingConverter.h"
#include "debug_msg.h"

// -----------------------------------------
const unsigned long CEncodingConverter::ENCODING_BUFFER_SIZE;


// -----------------------------------------
CEncodingConverter::CEncodingConverter()
  {
  m_handler_to_utf8 = (iconv_t)-1;
  m_handler_from_utf8 = (iconv_t)-1;
  m_buffer = NULL;
  }


// -----------------------------------------
CEncodingConverter::~CEncodingConverter()
  {
  }


// -----------------------------------------
int CEncodingConverter::Init(char* encoding)
  {
  m_handler_to_utf8 = iconv_open("UTF-8",encoding);
  if(m_handler_to_utf8 == (iconv_t)-1)
    {
    DEBUG_MSG_ERR("�������⨬�� ����஢�� %s/n", encoding);
    return -1;
    }

  m_handler_from_utf8 = iconv_open(encoding, "UTF-8");
  if(m_handler_from_utf8 == (iconv_t)-1)
    {
    DEBUG_MSG_ERR("�������⨬�� ����஢�� %s/n", encoding);
    return -1;
    }

  m_buffer = new unsigned char[ENCODING_BUFFER_SIZE];
  if(m_buffer == NULL) //!! catch(bad_alloc)
    {
    return -1;
    }
  memset(m_buffer, 0, ENCODING_BUFFER_SIZE);

  return 0;
  }


// -----------------------------------------
void CEncodingConverter::Deinit()
  {
  if(m_handler_to_utf8!=(iconv_t)-1)
    {
    iconv_close(m_handler_to_utf8);
    m_handler_to_utf8=(iconv_t)-1;
    }

  if(m_handler_from_utf8!=(iconv_t)-1)
    {
    iconv_close(m_handler_from_utf8);
    m_handler_from_utf8=(iconv_t)-1;
    }

  if(m_buffer!=NULL)
    {
    delete[] m_buffer;
    m_buffer = NULL;
    }

  }


// -----------------------------------------
char* CEncodingConverter::To_UTF8(char* str)
  {
  if(m_handler_to_utf8==NULL)
    return NULL;

  char* in_ptr = str;
  size_t in_len = strlen(str);

  char* out_ptr = (char*)m_buffer;
  size_t out_len= ENCODING_BUFFER_SIZE;
 
  #ifdef  __TeconP06__
  if( iconv( m_handler_to_utf8, (const char**)&in_ptr, &in_len, &out_ptr, &out_len) <0 )   
  #else
  if( iconv( m_handler_to_utf8, (char**)&in_ptr, &in_len, &out_ptr, &out_len) <0 )   
  #endif
  
    {
    DEBUG_MSG_ERR("Encoding failed.\n");
    return NULL;
    }

  *out_ptr = 0; // iconv ᤢ����� 㪠��⥫� �� ����� ������祭��� ��ப�. ���� �⠢�� �㤠 0. 

  return (char*)m_buffer;
  }


// -----------------------------------------
char* CEncodingConverter::From_UTF8(char* str)
  {
  if(m_handler_from_utf8==NULL)
    return NULL;

  char* in_ptr = (char*)str;
  size_t in_len = strlen((char*)str);

  char* out_ptr = (char*)m_buffer;
  size_t out_len= ENCODING_BUFFER_SIZE;
 
  #ifdef __TeconP06__
  if( iconv( m_handler_from_utf8, (const char**)&in_ptr, &in_len, &out_ptr, &out_len) <0  )   
  #else
   if( iconv( m_handler_from_utf8, (char**)&in_ptr, &in_len, &out_ptr, &out_len) <0  )   
  #endif
    {
    DEBUG_MSG_ERR("Encoding failed.\n");
    return NULL;
    }

  *out_ptr = 0; // iconv ᤢ����� 㪠��⥫� �� ����� ������祭��� ��ப�. ���� �⠢�� �㤠 0. 

  return (char*)m_buffer;
  }


