#ifndef _CENCODINGCONVERTER_H_
#define _CENCODINGCONVERTER_H_


#include <iconv.h>

// ����஢��, � ���ன ��࠭����� xml-䠩��
#define KRUGDB_XML_ENCODING "CP866"

// �����-��४���஢騪 �� UTF8 � ���� ����� ����஢��.
// UTF8 - ��⮬�, �� ⮫쪮 � �⮩ ����஢��� ࠡ�⠥� libxml2.
// � ��⥬� �㦭�, �⮡ �� ��⠭������ ���� iconv - ��� � �ᯮ������ ��� ��४���஢����.
class CEncodingConverter  {
  protected:
    /// ������ ���� ��� �࠭���� ��ப�-१����
    static const unsigned long ENCODING_BUFFER_SIZE = 4096;
    /// ���� ��� �࠭���� ��ப�-१����
    unsigned char* m_buffer;

    iconv_t m_handler_to_utf8;
    iconv_t m_handler_from_utf8;

  public:
    CEncodingConverter();
    ~CEncodingConverter();

    int      Init(char* encoding);
    void     Deinit();

    char* To_UTF8(char* str);
    char*    From_UTF8(char* str);

    int      Reset();
  };

#endif
