/*
 * CIniFile.cpp
 *
 *  Created on: Mar 31, 2013
 *      Author: root
 */

#include "CIniFile.h"
#include "deelx.h"
#include "CEncodingConverter.h"
namespace IniFile
{

CIniFile::CIniFile(string filepath)
{
   this->m_filepath=filepath;
}

CIniFile::~CIniFile()
{
}
int CIniFile::Load()
{
  m_file.open(m_filepath.c_str(),std::ios_base::in);
  if(m_file.is_open())
  {
     static CRegexpT<char> SectionRegExp("^\\[.*\\]$");
     static CRegexpT<char> ParamValueRegExp("(.*)=(.*)");
     static CRegexpT<char> CommentRegExp(":.*");
  	CEncodingConverter encConverter;
  	encConverter.Init("cp866");
     SECTION section;
     int stringcount=0;
     while(!m_file.eof())
     {
         char buf[4096]={0};
         m_file.getline(buf,sizeof(buf),'\n');

         MatchResult res=CommentRegExp.Match(buf);
         if(res.IsMatched())
         {
           int pos=res.GetStart();
           memset(&buf[pos],0,sizeof(buf)-pos);
         }
			 res=SectionRegExp.Match(buf);
			 if(res.IsMatched())
			 {
				 section=buf;
				 section=section.replace(section.size(),1,"");
				 continue;
			 }
			 else
			 {
				 res=ParamValueRegExp.MatchExact(buf);
				 if(res.IsMatched())
				 {
					int param_pos_start=res.GetGroupStart(1);
					int param_pos_end=res.GetGroupEnd(1);
					int value_pos_start=res.GetGroupStart(2);
					int value_pos_end=res.GetGroupEnd(2);
					string param_value(buf);
		            PARAM param=param_value.substr(param_pos_start,param_pos_end-param_pos_start);
		            VALUE val=param_value.substr(value_pos_start,value_pos_end-value_pos_start);
		            param=encConverter.To_UTF8((char*)param.c_str());
		            val=encConverter.To_UTF8((char*)val.c_str());
		            section=encConverter.To_UTF8((char*)section.c_str());
		            m_data[section][param]=val;
				 }
			 }
     }
  }
  else
  {
    return FILE_NOT_EXIST;
  }
  m_file.close();
  return 0;
}
int CIniFile::Save()
{
  m_file.open(m_filepath.c_str(),std::ios_base::out|std::ios_base::trunc);
  if(m_file.is_open())
  {
	 	CEncodingConverter encConverter;
	 	encConverter.Init("cp866");

	for(DATA::iterator it=m_data.begin();it!=m_data.end();it++)
   {
     SECTION section=it->first;
     VALUES &values =it->second;

     m_file<<encConverter.From_UTF8((char*)section.c_str())<<endl;
     for(VALUES::iterator it1=values.begin();it1!=values.end();it1++)
     {
       PARAM param=it1->first;
       VALUE val=it1->second;
       m_file<<encConverter.From_UTF8((char*)param.c_str())<<"="<<encConverter.From_UTF8((char*)val.c_str())<<endl;
     }
   }
  }
  else
  {
   return -1;
  }
  m_file.close();
  return 0;
}
char CIniFile::GetSectionData(SECTION section,VALUES & values)
{
  if(m_data.find(section)==m_data.end())
  {
    return -1;
  }
  values=this->m_data[section];
  return 0;
}
char CIniFile::SetSectionData(SECTION section,VALUES &data)
{
  m_data[section]=data;
  return 0;
}
char CIniFile::GetValue(SECTION section,PARAM param,VALUE &val)
{
  if(m_data.find(section)==m_data.end())
  {
    return -1;
  }
  if(m_data[section].find(param)==m_data[section].end())
  {
    return -1;
  }
  val= m_data[section][param];
  return 0;
}
char CIniFile::SetValue(SECTION section,PARAM param,VALUE val)
{
  m_data[section][param]=val;
 return 0;
}

} /* namespace IniFile */
