/*
 * CIniFile.h
 *
 *  Created on: Mar 31, 2013
 *      Author: root
 */

#ifndef CINIFILE_H_
#define CINIFILE_H_
#include <fstream>
#include <map>
#include "deelx.h"
#define FILE_NOT_EXIST -1
#define FILE_IS_EMPTY -2

using namespace std;
namespace IniFile
{
  typedef std::string PARAM;
  typedef std::string VALUE;
  typedef std::string SECTION;
  typedef map<PARAM,VALUE> VALUES;
  typedef map<SECTION,VALUES> DATA;
  class CIniFile
  {
  private:
    string m_filepath;
    fstream m_file;
    DATA m_data;
  public:
    CIniFile(string filepath);
    int Load();
    int Save();
    char GetSectionData(SECTION section,VALUES & values);
    char SetSectionData(SECTION section,VALUES &data);
    char GetValue(SECTION section,PARAM param,VALUE &val);
    char SetValue(SECTION section,PARAM param,VALUE val);
    DATA &GetData(){return m_data;};
    virtual ~CIniFile();
  };

} /* namespace IniFile */
#endif /* CINIFILE_H_ */
