#ifndef __DEBUG_MSG_H__
#define __DEBUG_MSG_H__
 
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
       
#define STRINGIFY(x)	STRINGIFY2(x)
#define STRINGIFY2(x)	#x

#ifndef _DEBUG
# define DEBUG_LOCATION ""
# define DEBUG_MSG(format, args...)		
# define DEBUG_MSG_ERR(format, args...)
#else
# define DEBUG_LOCATION					__FILE__ ":" STRINGIFY(__LINE__)
# define DEBUG_MSG(format, args...)		printf(format "", ##args)
	
//# define DEBUG_MSG_ERR(format, args...)	printf("* " DEBUG_LOCATION "(%s): " format "", __FUNCTION__ , ##args)

#define PROTOCOL_EXTRA_FILE_X "/tmp/parser.log"

#define DEBUG_MSG_ERR(format, args...) \
{\
        char file_name[200];\
        sprintf(file_name,"%s_%d.log",PROTOCOL_EXTRA_FILE_X, getpid() );\
        FILE *file = fopen(file_name , "a");\
        if(file)\
        {\
           fprintf(file, "\t<%d>%s:%d: " format "\n",getpid(),__FILE__,__LINE__, ##args); \
           fclose(file);\
         }\
} 

#endif

#endif // __DEBUG_MSG_H__
