#include <iostream>
#include <sstream>
#include <string>
#include "common.h"
#include "CIniFile.h"
#include "deelx.h"
#include "CCgiRequest.h"
#include <ui_lib.h>
using namespace std;
using namespace IniFile;

string Extract_ttyS_Number(string s)
{
	static CRegexpT<char> RegExp("ttyS(\\d{1,5})_add");
	MatchResult res=RegExp.MatchExact(s.c_str());
	if(res.IsMatched())
	{
        int pos_start=res.GetGroupStart(1);
        int pos_end=res.GetGroupEnd(1);
        s=s.substr(pos_start,pos_end-pos_start);
	}
	else
	{
	 s="";
	}
  return s;
}
int main(int argc, char *argv[]) {
	std::string querystring(getenv("QUERY_STRING"));
	CCgiRequest req(querystring);
	string sectionname = '[' + req.GetValue("section") + ']';
    string title=req.GetValue("section");
    title=Extract_ttyS_Number(title);
    int com_number=atoi(title.c_str())+1;
    stringstream s;
    s<<"Порт №"<<com_number<<"(ttyS"<<title<<")";
	string mode = req.GetValue("mode");
	CIniFile file("/gsw/settings/mtpconf.ini");
	int res = file.Load();
	if (mode == "load") {
		cout << PAGE_HEADER << endl;
		cout << JAVASCRIPT << endl;
		cout<<"<p align=\"center\"> <h2>"<< s.str()<<"</h2></p>";

		VALUES values;
		file.GetSectionData(sectionname, values);
		string tty_ctrl_name = string("tty") + req.GetValue("section");
		if(values["tty"].size()==0)
		{
			values["tty"]="ttyS2";
		}
		string tty_ctrl = ui_textbox(tty_ctrl_name, values["tty"], "30", "0", "50", "id=\"" + tty_ctrl_name+"\"");
		string tty = req.GetValue("section");
		tty = tty.substr(0, tty.find("_add"));
		string remoteport_ctrl_name = string("tty") + req.GetValue("section");
		string remoteport_ctrl =  ui_textbox(remoteport_ctrl_name, values["port"], "30", "0", "50", "id=\"" + remoteport_ctrl_name+"\"");

		string tel_ctrl_name = string("tel") + req.GetValue("section");
		string tel_ctrl =  ui_textbox(tel_ctrl_name, values["tel"], "30", "0", "50", "id=\"" + tel_ctrl_name+"\"");

		string tout_ctrl_name = string("tout") + req.GetValue("section");
		if(values["tout"].size()==0)
		{
			values["tout"]="60";
		}

		string tout_ctrl =  ui_textbox(tout_ctrl_name, values["tout"], "30", "0", "50", "id=\"" + tout_ctrl_name+"\"");

		string com_baud_Ctrl_name=string("com_baud")+req.GetValue("section");
		COMBOBOX_OPTIONS_INT com_baud_options;
		com_baud_options[300]=300;
		com_baud_options[1200]=1200;
		com_baud_options[2400]=2400;
		com_baud_options[4800]=4800;
		com_baud_options[9600]=9600;
		com_baud_options[19200]=19200;
		com_baud_options[38400]=38400;
		com_baud_options[57600]=57600;
		com_baud_options[115200]=115200;
		if(values["com_baud"].size()==0)
		{
			values["com_baud"]="115200";
		}
		string com_baud_Ctrl=ui_select(com_baud_Ctrl_name,atoi(values["com_baud"].c_str()),com_baud_options,"1","0","0","0","id=\""+com_baud_Ctrl_name+"\"");



		COMBOBOX_OPTIONS_STR com_databits_options;
		com_databits_options["5"]="5";
		com_databits_options["6"]="6";
		com_databits_options["7"]="7";
		com_databits_options["8"]="8";
	    if(values["com_databits"].size()==0)
	    {
	    	values["com_databits"]="8";
	    }
	    string com_databits_Ctrl_name=string("com_databits")+req.GetValue("section");
		string com_databits_Ctrl=ui_select(com_databits_Ctrl_name,values["com_databits"],com_databits_options,"1","0","0","0","id=\""+com_databits_Ctrl_name+"\"");


		COMBOBOX_OPTIONS_STR ccom_stopbits_options;
		ccom_stopbits_options["1"]="1";
		ccom_stopbits_options["2"]="2";

	    if(values["com_stopbits"].size()==0)
	    {
	    	values["com_stopbits"]="1";
	    }
	    string com_stopbits_Ctrl_Name=string("com_stopbits")+req.GetValue("section");
	    string com_stopbits_Ctrl=ui_select(com_stopbits_Ctrl_Name,values["com_stopbits"],ccom_stopbits_options,"1","0","0","0","id=\""+com_stopbits_Ctrl_Name+"\"");


		COMBOBOX_OPTIONS_STR parity_options;
		parity_options["not"]="not";
		parity_options["odd"]="odd";
		parity_options["even"]="even";
		parity_options["mark"]="mark";
		parity_options["space"]="space";

	    if(values["com_parity"].size()==0)
	    {
	    	values["com_parity"]="not";
	    }
	    string parity_Ctrl_Name=string("com_parity")+req.GetValue("section");
		string parity_Ctrl=ui_select(parity_Ctrl_Name,values["com_parity"],parity_options,"1","0","0","0","id=\""+parity_Ctrl_Name+"\"",true);

	    if(values["Init_str"].size()==0)
	    {
	    	values["Init_str"]="";
	    }

		string InitialString_Ctrl_Name=string("Init_str")+req.GetValue("section");
		string InitialString_Ctrl=ui_textbox(InitialString_Ctrl_Name, values["Init_str"], "30", "0", "256", "id=\"" + InitialString_Ctrl_Name+"\"");
		string applyBtn =
				ui_button(
						"Применить",
						"",
						false,
						"onclick=\"eval(document.getElementById('_onApply_').innerHTML)\"");
		string closeBtn =
				ui_button(
						"Закрыть",
						"",
						false,
						"onclick=\"eval(document.getElementById('_onClose_').innerHTML)\"");

		cout << ui_form_start() << endl;
		cout<<ui_hidden("dlg_width","550px");
		cout<<ui_hidden("dlg_height","400px");
		cout << "<div align=\"left\" id=\"parametras\">" << endl;
		cout << ui_hidden("section", req.GetValue("section"));
		cout<<"<table width=\"100%\">";
		cout<<"<tr width=\"50%\">";
		cout << "<td>Mодем: </td><td>";
		cout<<"<div style=\"width:100%\">";
		cout<<"<table width=\"100%\">";
		cout<<"<tr>";
		cout<<"<td width=\"50%\">Порт:</td><td>"<<"(ttyS<номер>)<br>"<<tty_ctrl<<"</td>";
		cout<<"</tr>";
		cout<<"<tr>";

		cout << "<td width=\"50%\">Скорость:</td><td>" << com_baud_Ctrl << "</td>" << endl;
		cout<<"</tr>";
		cout<<"<tr>";
		cout << "<td width=\"50%\">Кол-во бит данных:</td><td>" << com_databits_Ctrl << "</td>" << endl;
		cout<<"</tr>";
		cout<<"<tr>";
		cout << "<td width=\"50%\">Чётность:</td><td>" << parity_Ctrl << "</td>" << endl;
		cout<<"</tr>";
		cout<<"<tr>";
		cout << "<td width=\"50%\">Кол-во стоп-бит:</td><td>" << com_stopbits_Ctrl << "</td>" << endl;
		cout<<"</tr>";
		cout<<"<tr>";
		cout << "<td width=\"50%\">Стр. инициализации:</td><td>" << InitialString_Ctrl << "</td>" << endl;
		cout<<"</tr>";
		cout<<"</table>";
		cout<<"</div>";
		cout<<"</td>"<< endl;
		cout<<"</tr>";
		cout<<"<tr width=\"40%\">";
		cout << "<td>Телефонный номер:</td><td>" << tel_ctrl << "</td>" << endl;
		cout<<"</tr>";
		cout<<"<tr width=\"40%\">";
		cout << "<td>Таймаут CSD-канала (с):</td><td>" << tout_ctrl << "<td>" << endl;
		cout<<"</tr>";
		cout<<"</table>";
		cout << "<p align=\"center\">" << endl;
		cout << "<table width=\"100%\">" << endl;
		cout << "	 <tr>" << endl;
		cout << "	<td align=\"center\">" << endl;
		cout << applyBtn << endl;
		cout << "	</td>" << endl;
		cout << "	<td align=\"center\">" << endl;
		cout << closeBtn << endl;
		cout << "	</td>" << endl;
		cout << "	</tr>" << endl;
		cout << "	</p>" << endl;
		cout << "</div>" << endl;
		cout << ui_form_end() << endl;
		cout << "<div id=\"status\"></div>" << endl;
		cout << "</body>" << endl;
		cout << "</html>" << endl;
	}else if(mode=="save") {
		cout << PAGE_HEADER << endl;
		string tty=req.GetValue("tty");
		string tel=req.GetValue("tel");
		string tout=req.GetValue("tout");
		string com_baud=req.GetValue("com_baud");
		string com_databits=req.GetValue("com_databits");
		string com_stopbits=req.GetValue("com_stopbits");
		string com_parity=req.GetValue("com_parity");
		string Init_str=req.GetValue("Init_str");

		file.SetValue(sectionname,"tty",tty);
		file.SetValue(sectionname,"tel",tel);
		file.SetValue(sectionname,"tout",tout);
		file.SetValue(sectionname,"com_baud",com_baud);
		file.SetValue(sectionname,"com_databits",com_databits);
		file.SetValue(sectionname,"com_stopbits",com_stopbits);
		file.SetValue(sectionname,"com_parity",com_parity);
		file.SetValue(sectionname,"Init_str",Init_str);
		file.SetValue(sectionname,"string",tty+", tel-"+tel+",tout-"+tout);
		file.Save();
	}
	return 0;
}
