#!/usr/bin/perl
use WebminCore;
init_config();
require './parse_file-lib.pl';
require '../waitbox.pl';
my $script =
    "<script language=javascript src='../WaitBox.js'> </script>"."\n".
    "<script language=javascript src='RSSetup.js'> </script>" . "\n"
  . '<meta http-equiv="Content-Type" content="text/html"; charset="utf8">';
 print ui_print_header( undef, "Настройка последовательных портов",
                       "", undef, undef, 1, undef, undef, $script ); 
ShowWaitBox("Выполняется сохранение данных...","none");
my %settings=LoadKrugSettings();
my $path=$settings{'GSW_SETTINGS'}."uarts.ini";
if(!(-e "/gsw/uartscfg"))
{
print <<EOF
   <p align="left"><font color="RED">
   <b> 
     Данная модификация контроллера не поддерживает программную настройку последовательных портов.
     При необходимости настройка производиться при помощи джамперов на плате контроллера. 
     Подробнее см. Руководство по экплуататции.   
   </b>
   </font>
   </p>
EOF
;
	
	exit;
}
my %Data=GetIniFileData($path);
print  '<div id="main_div" style="display:block;">';
print ui_form_start("submit.cgi");
my $GroupBox_UART0_UARTDB=ui_radio("GroupBox_UART0_UARTDB",$Data{'[SETUP]'}{'ctrl0D'},[[1,"UARTDB + UART0<br />","onClick=\"Msg1(event)\""],[0,"UART0",,"onClick=\"Msg2(event)\""]]);
my $GroupBox_UART3_UART2=ui_radio("GroupBox_UART3_UART2",$Data{'[SETUP]'}{'ctrl23'},[[1,"UART3(RS-485) + UART2(RS-485)<br />","onClick=\"Msg3(event)\""],[0,"UART3(RS-422)","onClick=\"Msg4(event)\""]]);
my $GroupBox_UART5_UART4=ui_radio("GroupBox_UART5_UART4",$Data{'[SETUP]'}{'ctrl45'},[[1,"UART5(RS-485) + UART4(RS-485)<br />","onClick=\"Msg5(event)\""],[0,"UART5(RS-422)","onClick=\"Msg6(event)\""]]);
my $UART0_UARTDB_DSC=();
my $UART3_UARTD2_DSC=();
my $UART5_UARTD4_DSC=();
if($Data{'[SETUP]'}{'ctrl0D'}==1)
{
	$UART0_UARTDB_DSC="<p class=\"DivDescription\">Порт №1(ttyS0) - отладочный <br> Порт №2(ttyS1) - усечённый</p>";
}
else
{
	$UART0_UARTDB_DSC="<p class=\"DivDescription\">Порт №1(ttyS0) - полный</p>";	
}
if($Data{'[SETUP]'}{'ctrl23'}==1)
{
	$UART3_UARTD2_DSC="<p class=\"DivDescription\">Порт №4(ttyS3) - RS485 <br> Порт №5(ttyS4) - RS485</p>"
}
else
{
	$UART3_UARTD2_DSC="<p class=\"DivDescription\">Порт №5(ttyS4) - RS422</p>"	
}
if($Data{'[SETUP]'}{'ctrl45'}==1)
{
	$UART5_UARTD4_DSC="<p class=\"DivDescription\">Порт №6(ttyS5) - RS485 <br> Порт №7(ttyS6) - RS485</p>"	
}
else
{
	$UART5_UARTD4_DSC="<p class=\"DivDescription\">Порт №7(ttyS6) - RS422</p>"		
}

print <<EOF
<style>
.Legend
{
 color:#5555FF;
 font-weight:bold;	
}
.GroupBox
{
	-webkit-border-radius:10px;
	-moz-border-radius:10px;
	border-radius:10px;
	-khtml-border-radius:10px;
	width:300px;
	margin-right:10px;
	margin-left:10px;
	margin-top:10px;
	margin-bottom:10px;
	border:1px solid #cccccc;
		
}
.Caption
{
 color:black;
 font-weight:bold;
 text-align:center;			
}
.table
{
	border-collapse:collapse;
	border:1px solid #cccccc;
	width:800px;	
}
.table td
{
	border-collapse:collapse;
	border:2px solid #ccc;
}

.EmptyBorder
{
	border:0px;	
}
.EmptyBorder td
{
	border:0px;		
}
.DivDescription
{
	color: green;
    font-weight:bold;
    text-align:center;		
}
   .r1, .r2,  .r3, .r4 {
    display: block; 
    height: 1px;
    background: #f677c5;
    overflow: hidden;
   }
   .r1 {  margin: 0 5px; }
   .r2 {  margin: 0 3px; }
   .r3 {  margin: 0 2px; }
   .r4 {  margin: 0 1px; height: 2px; }
   .block-round-content { 
    background: #f677c5; /* Цвет фона */
    padding: 10px; /* Поля вокруг текста */
  }

</style>

<table class="table"> 
  <tr>
       <td width="20%" class="Caption">
         <b>Разъём RS-232</b>
       </td>
       <td >
        <table class="EmptyBorder">
         <tr>
		   <td>
		     <fieldset class="GroupBox">
		     <legend class="Legend">
		      UART0 / UARTDB
		     </legend>
                $GroupBox_UART0_UARTDB
		     </fieldset>      
           </td>
           <td>
             <div id="UART0_UARTDB_DESC">
              $UART0_UARTDB_DSC
             </div>
           </td>
         </tr>
        </table>
       </td>
  </tr>
  <tr>
    <td width="20%" class="Caption">
      Разъём RS-485/422
    </td>
    <td>
		<table class="EmptyBorder">
		  <tr>
		    <td>
				<fieldset class="GroupBox">
				<legend class="Legend">
				 UART3 / UART2
				</legend>
		         $GroupBox_UART3_UART2
				</fieldset>
		    </td>
           <td width="35%">
             <div id="UART3_UART2_DESC">
              $UART3_UARTD2_DSC
             </div>
           </td>
		  </tr>
		  <tr>
		    <td>
				<fieldset class="GroupBox">
				<legend class="Legend">
				 UART5 / UART4
				</legend>
		         $GroupBox_UART5_UART4
				</fieldset>
		    </td>
           <td width="35%">
             <div id="UART5_UART4_DESC">
              $UART5_UARTD4_DSC
             </div>
           </td>
		  </tr>		               
		</table>             
    </td>   

  </tr>
</table>
EOF
;    
print '<p align="center">',ui_submit("Применить",undef,undef),"</p>";
print ui_form_end();
