#!/usr/bin/perl
use Switch;  
use WebminCore;
use feature ":5.10";
init_config();
require 'parse_file-lib.pl';
require '../waitbox.pl';
my $script =
    "<script language=javascript src='../WaitBox.js'> </script>"."\n".
    "<script language=javascript src='submit.js'> </script>" . "\n"
  . '<meta http-equiv="Content-Type" content="text/html"; charset="utf8">';
print ui_print_header( undef, $text{'SEV_title'},
                       "", undef, undef, 1, undef, undef, $script,'onload="OnPageLoad(event)"' );
 ShowWaitBox("Выполняется сохранение настроек...","none");                      
print  '<div id="main_div" style="display:block;">';
print ui_form_start( 'submit.cgi','post');
BuildInterface();
print ui_form_end();
print "</div>";
sub BuildInterface()
{
my %KrugSettings=LoadKrugSettings();
my $SEVDataPath = $KrugSettings{'GSW_GUICFG'}.'sev.data';
my $SEVGuiCfg =   $KrugSettings{'GSW_GUICFG'}.'sev/sevIface.config';
my $ntpcnfPath = $KrugSettings{'GSW_ETC'}.'ntp.cnf';
my %defValues    = ParseInterfaceConfig($SEVGuiCfg);
my %FileData = LoadConfig( $ntpcnfPath);
   %FileData = RestoreDefaults( \%defValues, \%FileData );
print ui_form_start('.\submit.cgi','post');
print ui_columns_start(['Параметр','Значение']); 
my %params = %{$defValues{'[SEV]'}};
foreach $param (sort{$params{$a}{'Order'}<=>$params{$b}{'Order'}} keys %params)
{
 my $control;
 switch ($params{$param}{'Type'})
 {
  case "EditBox" {
   $control = ui_textbox($params{$param}{'Param'},$FileData{'[SEV]'}{$param},50,0,15);
  }
  case "ComboBox"
  {
   my @tmpvalues = split(',',$params{$param}{'Values'});
   my @values=();
   for(my $i=0;$i<(scalar(@tmpvalues));$i++)
   {
    my ($code,$val) = split(';',$tmpvalues[$i]);
    push(@values,[$code,$val]);
   }
   my $script=();
   if($params{$param}{'Param'}eq "workmode")
   {
      $script='onChange="workmode_click(event)"';  
   }
   $control = ui_select($params{$param}{'Param'},$FileData{'[SEV]'}{$param},[@values],1,0,undef,0,$script);   
  }
 }
 print ui_columns_row([$params{$param}{'Caption'},$control]);
}
print ui_columns_end();
print '<p align="center">',ui_submit("Применить","Применить",0,'onclick="ShowWaitBox();"'),'</p>';
print ui_form_end();

}
sub LoadConfig( )
{
	my ($ntpcnfPath)=@_;
	my %Data=();
    my @output=`cat $ntpcnfPath`;

    foreach $str (@output)
    {
     	given ($str)
     	{
     	  when (/^statistics/)
     	  {
     	  	$Data{'[SEV]'}{'statistic'}=1;
     	  }
     	  when (/^broadcast\syes/)
     	  {
     	  	$Data{'[SEV]'}{'workmode'}=1;     	  	
     	  }	
     	  when (/^server\s(\S+)\sminpoll\s(\d{1,3})\smaxpoll\s(\d{1,3})/)
     	  {
     	  	$Data{'[SEV]'}{'workmode'}=0;
     	  	$Data{'[SEV]'}{'address'}="$1";
     	  	$Data{'[SEV]'}{'mininterval'}="$2";
     	  	$Data{'[SEV]'}{'maxinterval'}="$3";   	  	     	  	     	  	
     	  }
     	}
    } 
 return %Data;	
}
