BEGIN { push(@INC,".."); 
push(@INC,"/usr/libexec/webmin/net","/usr/lib/perl5/5.8.8/Tie");
push( @INC, "/usr/share/lib/Perl5/Tie","/usr/share/webmin/net");
};
use Switch;
use WebminCore;
require 'net-lib.pl';
init_config();
use Tie::IxHash;
use Encode qw( from_to is_utf8 ); 
# восстановить значения параметров настроек ком-порта
# данные беруться из файла intreface.config 
sub RestoreCOMParametras()
{
  my ($FileData,$interfaceSections,$ComPort) = @_;
  my %ComInterfaces=GetCOMInterfaces();
  my %Data = %$FileData;
  my %iFaceSect = %$interfaceSections;
       my $iFaceComSect =$ComPort;
       $iFaceComSect =~s/(\d.*)//g;
       $iFaceComSect = "[".$iFaceComSect."]";
       foreach my $section(keys %iFaceSect)
       {
          if($section ne $iFaceComSect)
          {
           next;
          }
          foreach my $par(keys %{$iFaceSect{$section}})
          {
            if(!defined($Data{"[".$ComPort."]"}{$par}))
            {
              $Data{"[".$ComPort."]"}{$par} = $iFaceSect{$section}{$par}{'DefValue'};           
            }
        
          }
       }      
  return %Data;
}
sub LoadKrugSettings()
{
  my @output = `cat /gsw/etc/krug.env`;
  my %data = ();
  foreach $s (@output)
  {
    chomp ($s);
    $_ = $s;
    if(/(\.*)\=(\.*)/)
    {
        my $tmp = "$'";
        $data{"$`"}=$tmp; 
    }
  }
  return %data;
}
#сохранить данные в файл 
# переаметры - хеш с пользовательскими данными
sub Save()
{
  my (%userdata) = @_;
  my %KrugSettings = LoadKrugSettings();
  my $path = $KrugSettings{'GSW_GUICFG'}."IP2RS.data";     
  my %filedata = ParseKrugKntrIniFile($path);
  foreach my $section (keys %userdata)
  {
    foreach my $param (keys %{$userdata{$section}})
    {      
      $filedata{$section}{$param}=$userdata{$section}{$param};
    }
  };
  
 my $OUTFILE;
 
 open(OUTFILE, ">".$path) or die print "sdfsdfsdfsdf";
  foreach my $section (keys %filedata)
  {
    my $s=$section;
    from_to($s,"utf8","cp866");
    print OUTFILE $s,"\n";
#    print  $s,"\n";
    foreach my $param (keys %{$filedata{$section}})
    {
      my $v=$filedata{$section}{$param};
         from_to($v,"utf8","cp866");
      my $p = $param;
         from_to($p,"utf8","cp866");    
      print OUTFILE $p,"=",$v,"\n";
      
    }
  } 
  close(OUTFILE); 
 #перезапуск утилиты Ser2Net
 Ser2NetRestart(%filedata) 
}
sub Ser2NetRestart()
{
  my %data =@_;
  my $ser2netConfig;
  my $additionalParams="";
  my %KrugSettings = LoadKrugSettings();
  my $path =$KrugSettings{"GSW_SETTINGS"}."ser2net.conf"; 
  open (ser2netConfig,">$path") or die print "Невозможно создать файл /gsw/etc/ser2net.conf";
  my $configstr;
  foreach my $section(keys %data)
  {
     $_ = $section;
     if($_=~/(\w+)_(\w+)/)
     {
        my $status = $data{$section}{'status'};
        if($status==1)
        {
        my $port = $data{$section}{'port'};
        my $eth = $data{$section}{'eth'};
        my $comname = "[$2]";
        my $portname = "$2";      
        if($eth=~s/(\{)|(\})|(eth\d{1,2}\s)|(ALL)//g)
        {
           if(length($eth)!=0)
            {
             $configstr=$eth.','.$port.':raw:';     
            }
            else
            {
             $configstr=$port.':raw:';
            }
            $configstr=$configstr.$data{$section}{'timeout'}.':';
            $configstr=$configstr."/dev/".$portname.':';
            $configstr=$configstr.$data{$comname}{'COM_SPEED'}.','.$data{$comname}{'COM_PARITY'}.',';
            if($data{$comname}{'COM_STOPBITS'}==1)
            {
               $configstr=$configstr.$data{$comname}{'COM_STOPBITS'}.'STOPBIT,';
            }
            else
            {
               $configstr=$configstr.$data{$comname}{'COM_STOPBITS'}.'STOPBITS,';
            }
            $configstr=$configstr.$data{$comname}{'COM_DATA'}.'DATABITS'.$additionalParams;
            print ser2netConfig $configstr,"\n";
        } 
        }            
     }
  }
  close(ser2netConfig);
  system("sh","/etc/init.d/s2net","restart");
}

# считать данные из файла конфигураций
sub ParseKrugKntrIniFile()
{
 my %KrugSettings = LoadKrugSettings();
 my $filename = $KrugSettings{"GSW_GUICFG"}."IP2RS.data"; 
 my %data = GetIniFileData($filename);
 $filename = $krugSettings{"GSW_GUICFG"}.'IP2RS'."interface.config";
 my %iFaceData = ParseInterfaceConfig($filename);
 return %data;
};
#чтение файлов конфигураций интерфейсов(interface.config)
sub ParseInterfaceConfig()
{
 my ($filename1) =@_;
 tie %Data,"Tie::IxHash";
 %Data = GetIniFileData($filename1);
 tie %Return_Data,"Tie::IxHash" ;
 for my $section (keys %Data)
 {
   for my $param (keys %{$Data{$section}})
   {
     my $Sect = "[".$Data{$section}{'Section'}."]";
     my $Par = $Data{$section}{'Param'};
     $Return_Data{$Sect}{$Par}{$param} = $Data{$section}{$param};
   }
 };
 return %Return_Data; 
}
# парсер файлов конфигураций
sub GetIniFileData()
{ 
 my ($filename) = @_;
 my $INIFILE;
 my $section;
 tie %Data, "Tie::IxHash";
 if(open(INIFILE, "<".$filename)!=0) 
 {
 while(<INIFILE>)
 {
   chomp;
   $_=~s/:.*//g;    

   if(/\[.+?\]/)  
   {     
     $section = $_;
     from_to($section,"cp866","utf8");
   }
   if(/(\.*)\=(\.*)/)
   {  
     $s ="$`";    
     $s=~s/:.*//g;
     from_to($s,"cp866","utf8");
     my $s1="$'";
     from_to($s1,"cp866","utf8");   
     $Data{$section}{$s} = $s1;  
   }  
 }
 close(INIFILE);
 } 
 return %Data; 
   
}

#получить список интерфейсов Ethernet
sub GetEthernetInterfaces()
{
 my @EthernetInterfaces = active_interfaces();
 my @IPInterfaces = ();
 foreach $interface (@EthernetInterfaces)
 {
   if($interface->{'fullname'}=~m/eth/)
   {
     push(@IPInterfaces,[$interface->{'fullname'}." {".$interface->{'address'}."}"]);
   }
 };
     push(@IPInterfaces,["ALL"]);
 
 return @IPInterfaces;
}
#получить список com-интерфейсов
sub GetCOMInterfaces()
{
 opendir(DIR,"/dev/");
 my @files= grep{/ttyS\d+$/} readdir(DIR); # выбираем файлы ttys*  из каталога/dev/
 my %ComportParams=(); #параметры com-порта 
 foreach $file (@files)
 {   
  my $cmdline = "setserial /dev/".$file;
  @output=`$cmdline`;
  my $comName;
  if(split("ttyS",$file))
  {
    $comName = "ttyS".$_[1];
  }                  
   for $s (@output) 
   {
    $_ = $s;
    $_=~s/\s*|(\Line\s\d)//g;    
    foreach $paramValue (split(",",$_))
    {
      if(split(":",$paramValue))
      {
          if(defined($_[1])) 
          {                               
            #исключаем порты которых нет физически. 
            #критерием исключения является занчение unknown параметра UART 
            if(($_[0]eq "UART") && ($_[1]eq "unknown"))
            {           
              delete $ComportParams{$comName};
              last;
            }
            $ComportParams{$comName}{$_[0]} = $_[1];
          }
          else
          {
            $_[0] =~s/\///g;
            $_[0] =~s/dev//g;
            $ComportParams{$comName}{'name'} = $_[0];
          }
      }
    }	    
   }	 
  }
 closedir(DIR);
 return %ComportParams;
}
sub RestoreDefaults()
{
 my ($defaults,$fileData)=@_; #значения по умолчанию
 my %defvalues=%$defaults;
 my %FileData=%$fileData;
foreach my $sect (keys %defvalues)
{
   foreach my $param (keys %{$defvalues{$sect}})
   {
      if(!defined($FileData{$sect}{$param}))
      {
      $FileData{$sect}{$param}=$defvalues{$sect}{$param}{'DefValue'};
      }
   }
}
 return %FileData;
}

sub ParsePPPDOptionsFile()
{
 my %pppOprionsData = ();
 my ($filename) = @_;
 my $INIFILE;
 my $s=();
 if(open(INIFILE, "<".$filename)!=0) 
 {
 my $section = "[PPPD_COMMON]";
 while(<INIFILE>)
 {
   chomp;
   $_=~s/:.*//g;    
  if(/^\w*$/)
  {
     from_to($_,"cp866","utf8");
     $pppOprionsData{$section}{$_}="novalue";
  } 
  #строка в виде "параметр значение" 
  if(/(\.*)\s(\.*)/)
   {  
     $s ="$`";    
     $s=~s/:.*//g;
     from_to($s,"cp866","utf8");
     my $s1="$'";
     from_to($s1,"cp866","utf8");   
     $pppOprionsData{$section}{$s} = $s1;
   } 
 }
 close(INIFILE);
 } 
return %pppOprionsData;  
}
