#!/usr/bin/perl
use WebminCore;
init_config();
require 'parse_file-lib.pl';
require '../waitbox.pl';
my $script =
    "<script language=javascript src='../../WaitBox.js'> </script> <script language=javascript src='./sms_abonents.js'> </script>" . "\n"
  . '<meta http-equiv="Content-Type" content="text/html"; charset="utf8">';
my %settings=LoadKrugSettings();
my %data=GetIniFileData($settings{'GSW_SETTINGS'}.'sms.ini');
print ui_print_header( undef, $text{'SMS_ABONENTS_title'},
                       "", undef, undef, 1, undef, undef, $script);
ShowWaitBox("Выполняется подготовка данных...","none");                       
if(IsSupport()!=1)
{
print <<EOF
   <p align="center">
    <font color="red"><b>Для работы данного плагина необходимо установить пакет Модуля удалённых соединений версии 1.2 или выше</b></font> 
  </p>
EOF
;
	exit;
}      
                 
print ui_form_start( '.\submit.cgi','post');
 %data=%{$data{'[ABONENTS]'}};
print  '<div id="main_div" style="display:block;">'; 
print '<p align="center">';
print ui_columns_start(['Абонент','Номер телефона'],35,0,["id=numbers_table"]);
foreach my $abonent ( sort{$a<=>$b} keys %data)
{
   print  ui_columns_row([ui_checkbox('status'.$abonent,1,"$abonent",0,'id="'.'status'.$abonent.'"'),
                    ui_textbox('number'.$abonent,$data{$abonent},30,0,20,'id="'.'number'.$abonent.'"').ui_hidden('abonent'.$abonent,$abonent) 
    ]);
}
print ui_columns_end();

print ui_button("Добавить абонента","addAbonent",0,"onclick=\"AddAbonent(event)\"").
      ui_button("Удалить выбранных абонентов","removeSelected",0,"onclick=\"RemoveSelected(event)\"").
      ui_button("Выделить всё","SelectAll",0,"onclick=\"selectAll()\"").
      ui_button("Снять выделение","UnselectAll",0,"onclick=\"unselectAll()\"").
      ui_submit("Применить",undef,0,"onclick=\"validate(event)\"");
print "</p>";
print ui_form_end();
print '</div>';
sub IsSupport()
{
  my $res=1;
  my $output=`dpkg -p mus |grep Version:|sed -r "s/Version:\\s+//g"`;
  my $ver_compare_result=Compare_Versions($output,"1.2");
  if ($ver_compare_result==-1) #$output<1.2
  {
  	$res=0;
  }    
  return $res;	
}
sub Compare_Versions()
{
 (my $left,my $right)=@_;
  my @l=split(/\./,$left);
  my @r=split(/\./,$right);
  
  if(scalar(@l)>scalar(@r))
  {
  	for($i=0;$i<(scalar(@l)-scalar(@r));$i++)
  	{
  		push(@r,"0");
  	}
  }
  if(scalar(@r)>scalar(@l))
  {
  	for($i=0;$i<(scalar(@r)-scalar(@l));$i++)
  	{
  		push(@l,"0");
  	}  	
  }
  my $result;
 for ($i=0;$i<scalar(@l);$i++)
 {
    if($l[$i]>$r[$i])
    {
      $result=1;
      return $result;	
    } else
    {
	    if($l[$i]==$r[$i])
	    {
	      $result=0;
	    }
	    else
	    {
		    if($l[$i]<$r[$i])
		    {
		      $result=-1;
		      return $result;	
		    }	    	
	    }    	
    } 	
 } 
 return $result;	
}