#!/usr/bin/perl
require '../parse_file-lib.pl';
require '../../waitbox.pl';
use WebminCore;
use feature ":5.10";
use CGI::Lite;
init_config();
my %settings = LoadKrugSettings();
my $paramFile = 'krugkntr.param'; #имя файла описания секций
$paramFile = $settings{"GSW_GUICFG"}."srvk_conf/".$paramFile;
my %interfaceParams=ParseInterfaceConfig($paramFile);
%interfaceParams=%{$interfaceParams{'[SMS]'}}; 
my @sortbyOrder_IfaceParams=sort{$interfaceParams{$a}{'Order'}<=>$interfaceParams{$b}{'Order'}}(keys %interfaceParams);

my $script =
    "<script language=javascript src='./smseditor.js'> </script>"."\n"
    ."<script language=javascript src='../../WaitBox.js'> </script>"."\n"
  . '<meta http-equiv="Content-Type" content="text/html"; charset="utf8">';
ui_print_header(undef,$text{'title'},"",undef,0,1,undef,undef,$script);
print '<p align="center">'.'(krugkntr.ini\SMS-Оповещение)<br><br><font size="4">Добавление оповещения</font></p>';
ShowWaitBox("Выполняется сохранение настроек...","none");
print  '<div id="main_div" style="display:block;">';
print ui_form_start('./SaveNewSMS.cgi',"post");
my $params_table=ui_columns_start(['Параметр','Значение'],75);
foreach $p(@sortbyOrder_IfaceParams)
{
			my $value=$interfaceParams{$p}{'DefValue'};
			my $control=();
			my $s=$interfaceParams{$p}{'Section'};
			given($interfaceParams{$p}{'Type'})
			{
				when("EditBox")
				{
					$control=ui_textbox($s.$interfaceParams{$p}{'Param'},$value);
				}
				when("ComboBox")
				{
					my @tmp=split(/,/,$interfaceParams{$p}{'Values'});
					my @Values=();
					foreach $v (@tmp)
					{
						(my $parameter,my $val)=split(/;/,$v);
						push(@Values,[$parameter,$val]);
					}
					$control=ui_select($s.$interfaceParams{$p}{'Param'},[$value],[@Values],1,0,0,0,0);
				}
				when("SMSEditPanel")
				{
					my @tmp=split(/,/,$interfaceParams{$p}{'Values'});
					my @Values=();
					foreach $v (@tmp)
					{
						(my $parameter,my $val)=split(/;/,$v);
						push(@Values,[$parameter,$val]);
					}
					my $msg_type=2;
					my $smscount=();
					$msg=~s/"//g;
					if($msg=~/^[^А-Яа-я]+$/)
					{
						$smscount=int(length($msg)/160)+1;
						if($smscount>1)
						{
						$smscount=int(length($msg)/152)	
						}
						if(length($msg)==0)
						{
							$smscount=0;
						}
					}
					else
					{
						$smscount=int(length($msg)/70)+1;
						if($smscount>1)
						{
						$smscount=int(length($msg)/67)	
						}
						if(length($msg)==0)
						{
							$smscount=0;
						}						
					}
					my $textareaId=$s.$interfaceParams{$p}{'Param'}."_text";
					my $textarea_color;
					my $textarea_readonly;
					if($msg_type==2)
					{
						$textarea_color="#D0D0D0";
						$textarea_readonly="readonly";
					}
					else
					{
					$textarea_color="#ffffff";
					$textarea_readonly="";	
					}
					my $textarea=ui_textarea($textareaId,
					                         $msg,
					                         3,
					                         50,
					                         "soft",
					                         0,
					                         'id="'.$textareaId.'"'."onKeyup=\"onkeypressed(event,'".$s.$interfaceParams{$p}{'Param'}."_symbols','".$s.$interfaceParams{$p}{'Param'}."_msg')\" style=\"background-color:".$textarea_color.'"'.$textarea_readonly);
					$control=ui_select($s.$interfaceParams{$p}{'Param'}."_status",[$msg_type],[@Values],1,0,0,0,'id="'.$s.$interfaceParams{$p}{'Param'}."_status".'"'."OnChange=\"OnComboChange(event)\"").
					         $textarea.
					         "<br>"."Количество символов: <span id='".$s.$interfaceParams{$p}{'Param'}."_symbols'>".length($msg)."</span><br>Количество сообщений: <span id='".$s.$interfaceParams{$p}{'Param'}."_msg'>".$smscount."</span>";					
				}
			}
			$params_table=$params_table.ui_columns_row([$interfaceParams{$p}{'Caption'},
			                                           $control]);
}
$params_table= $params_table.ui_columns_end();
print $params_table;
#print "<a href=\"./parametrasEx.cgi?filename=krugkntr.ini&sectionname=SMS\">К списку оповещений<a>";
print "<p align=\"center\">".ui_submit("Применить",undef,0," onclick=\"validate(event)\"").ui_button("Отмена","cancel",0,"onclick=\" ShowWaitBox();document.location='./parametrasEx.cgi?filename=krugkntr.ini&sectionname=SMS'\"")."</p>";
print " 
<table width=\"30%\">
  <tr>
    <td >
     <p><a href=\"../sections.cgi?filename=krugkntr.ini\">К списку секций</a></p>        
    <td>
    <td >
     <p><a href=\"../index.cgi\">К списку файлов</a></p>    
    <td>
  </tr>
  
</table>
";

print ui_form_end();
print "
<table width=\"100%\">
  <tr>
    <td width=\"10%\">
     <p><b>ПРИМЕЧАНИЕ:</b></p>        
    <td>
    <td >
     <ul>
     <li>Допустимо использование ссылок на переменные БД и их атрибуты, обрамляя их символами \"%\", например: 
     <br> %ВА2%, %АВ10.а39%.<br> 
     При использовании ссылок на переменные БД количество SMS-сообщений может быть больше, чем рассчитано.</li>
     <li>Для включения в текст сообщения символа \"%\" необходимо воспользоваться сочетанием символов\"%%\".</li>
     <ul>    
    <td>
  </tr>
  
</table>   
";

print "</Div>";