#!/usr/bin/perl
BEGIN { push(@INC,".."); 
push(@INC,"/usr/libexec/webmin/net");
};

use WebminCore;
init_config();
use feature ":5.10";
use CGI::Lite;
$cgi=new CGI::Lite();
my %params = $cgi->parse_form_data();


require 'parse_file-lib.pl';
require '../waitbox.pl';
my $script = "<script language=javascript src='../WaitBox.js'> </script>"."\n".
             "<script language=javascript src='validate.js'> </script>"."\n".
             '<meta http-equiv="Content-Type" content="text/html"; charset="utf8">';
my %settings = LoadKrugSettings();
my $sectionFile = $params{'filename'}; #имя файла описания секций
$sectionFile=~s/\.ini/\.sect/g;
$sectionFile = $settings{"GSW_GUICFG"}."srvk_conf/".$sectionFile;
my %SectionsInfo = GetIniFileData($sectionFile); 
my $sectionname_header=();
foreach $section(keys %SectionsInfo)
{
  if($SectionsInfo{$section}{'Name'}eq $params{'sectionname'})
  {
    $sectionname_header=$SectionsInfo{$section}{'Caption'};
  }  
}
print ui_print_header(undef,$text{'title'},"",undef,0,1,undef,undef,$script,'onload="hideErors(event)"');
ShowWaitBox("Выполняется сохранение настроек...","none");
print  '<div id="main_div" style="display:block;">';

print '<p align="center">'."(".$params{'filename'}."\\".$sectionname_header.")</p>";
my $submitLink ='submit.cgi';

print ui_form_start($submitLink,'post',undef);

print ui_hidden('filename',$params{'filename'});
# в случае добавления новой секции запоминаем введенное пользователем имя новой секции
if(!defined($params{'newSectionName'}))
{
  print ui_hidden("sectionname",$params{'sectionname'});
}
else
{
  print ui_hidden("sectionname",$params{'newSectionName'});
}
my $paramsFile = $params{'filename'};
$paramsFile=~s/\.ini/\.param/g;
 my %settings= LoadKrugSettings();
$paramsFile = $settings{"GSW_GUICFG"}."srvk_conf/".$paramsFile;
my %ParamsInfo = GetParamsInfo($paramsFile);
my $filename=$settings{"GSW_SETTINGS"}.$params{'filename'};
my %data = GetIniFileData($filename);
my @header = ["Номер","Имя параметра","Значение","Описание",""];
#формируем интерфейс пользователя
BuildInterface(\%ParamsInfo,\@header,\%data);
print ui_form_end();
print '</div>';
sub BuildInterface()
{
my ($Info,$head,$data) = @_;
my %ParametrasInfo = %$Info; # описания параметров
my @header=@$head;# заголовок таблицы 
my %Data=%$data; # данные ини-файла
my @table =();
my $regexps = GetParamsValuesRegexps(\%ParametrasInfo,\%Data);
my $shortsectionname =$params{'shortsectionname'};
my $sectionname = $params{'sectionname'}; 
my @pageFooterRemarks=();
#если создаём новую секцию
if (defined($params{'newSectionName'}))
{   
   $sectionname=$params{'newSectionName'};   
   $_=$params{'newSectionName'};
   my $sectionregexp = $params{'sectionregexp'};
   if($_=~/$sectionregexp/)
   {        
    $shortsectionname="$1";
   }
}
# формируем интерфейс пользователя
foreach my $sect(keys %ParametrasInfo)
{
    if($shortsectionname ne $ParametrasInfo{$sect}{'Section'})
    {
      delete $ParametrasInfo{$sect};
    }  
}
  
   foreach my $sect(sort{$ParametrasInfo{$a}{'Order'}<=>$ParametrasInfo{$b}{'Order'}} keys %ParametrasInfo)
   {
     my $SectionName = $ParametrasInfo{$sect}{'Name'};# имя ini-файла с настройками СРВК   
     my $Control=();
         given ($ParametrasInfo{$sect}{'Type'})
         {
           when ("ComboBox")
           {
              @values = split(/\,/,$ParametrasInfo{$sect}{'Values'});   
              my @tmpvalues=();
              for ($i=0;$i<scalar(@values);$i++)
              {
                my $code_val = $values[$i];
                my ($code,$value)=split(/;/,$code_val);
                push(@tmpvalues,[$code,$value]);
              }         
              my $value=$data{'['.$sectionname.']'}{$ParametrasInfo{$sect}{'Param'}};
              if(!defined($value))
              {
                 $value = $ParametrasInfo{$sect}{'DefValue'};
              }
              my $controlName = $sectionname.$ParametrasInfo{$sect}{'Param'};
      	      $Control = ui_select($controlName,[$value],[@tmpvalues],1);
           }
           when ("EditBox")
           {
              my $editEvents = 'onfocus="onFocus(event)"';
              my $value=$data{'['.$sectionname.']'}{$ParametrasInfo{$sect}{'Param'}};
              if(!defined($value))
              {
                 $value = $ParametrasInfo{$sect}{'DefValue'};
              }
              my $controlName = $sectionname.$ParametrasInfo{$sect}{'Param'};
              $Control = ui_textbox($controlName,$value,15,0,30,"id=".'"'.$controlName.'" ');
           }
           when ("Remark") 
           {
              push(@pageFooterRemarks,$ParametrasInfo{$sect}{'Value'});
           }
           when ("ComportCombobox")
           {
			  @values = GetCOMInterfaces();    			  
              my $value=$data{'['.$sectionname.']'}{$ParametrasInfo{$sect}{'Param'}};
              if(!defined($value))
              {
                 $value = $ParametrasInfo{$sect}{'DefValue'};
              }
              my $controlName = $sectionname.$ParametrasInfo{$sect}{'Param'};
      	      $Control = ui_select($controlName,[$value],[@values],1);
				           	
           }
         }
           my $controlName =$sectionname.$ParametrasInfo{$sect}{'Param'}.'_err'; 
           my $err =ui_textbox($controlName,undef,40,0,300,"id=".'"'.$controlName.'" '); 
           #$regexps=$regexps+{$controlName}=$ParametrasInfo{$sect}{'Regexp'};
           if($ParametrasInfo{$sect}{'Type'}ne "Remark")
           {
             push (@table,
                     [$ParametrasInfo{$sect}{'Order'},
                      $ParametrasInfo{$sect}{'Caption'},
                      $Control,
                      $ParametrasInfo{$sect}{'Description'},
                      $err          
                      ]
                     );                   
           }
   }

print ui_columns_table(
	@header,
 100,
 \@table,
 undef,
 0,
 undef,
 undef
	);
	
print '<div align=center>';
print ui_submit('Применить',undef,0,'onclick="'.$regexps.'veryfiData_onSubmit(event,arr);"');
print "</div>";
if (defined($params{'newSectionName'}))
{
 print ui_hidden("newsection","");
}

print '<table width="30%">';
print '<tr><td>';
print '<p><a href="sections.cgi?filename='.$params{'filename'}.'">К списку секций</a></p>';
print '</td>';
print '<td>';
print '<p><a href="index.cgi"> К списку файлов</a></p>';
print '</td></tr>';
print '</table>';
if(scalar(@pageFooterRemarks)>0)
{
 PrintRemarks(@pageFooterRemarks);
}

}
#считать информацию о параметрах
sub GetParamsInfo()
{
 my ($filename) = @_;
 my %data = GetIniFileData($filename);
 return %data;
}
#возвращает строку на javascript, содержащуюю ассоциативный массив с регулярными 
#выражениями, формат ввода того или иного параметра 
sub GetParamsValuesRegexps()
{
  my ($Data,$iniFileData)=@_;
  my %data=%$Data; 
  my %IniFileData=%$iniFileData;
  my $result = "var arr=[]; ";
  foreach my $sect (keys %data)
  {
       my $sec=$data{$sect}{'Section'};
       my $name = $sec.$data{$sect}{'Param'};
       $result=$result."arr['".$name."']=".$data{$sect}{'Regexp'}."; ";
  }  
  return $result;
}
sub PrintRemarks()
{
 my (@remarks)=@_;
 print '<table width="100%">';
 print '<tr>';
 print '<td width=10%>';
 print '<b>Примечания:</b>';
 print '</td>';
 print '</tr>';
 foreach $rem (@remarks)
 {
   print '<tr>';
   print '<td  width=10%> </td>';
   print '<td>'.$rem.'</td>';
   print '</tr>';
 }
 print '</table>';
}
sub GetCOMInterfaces()
{
 opendir( DIR, "/dev/" );
 my @files = grep { /ttyS/ }readdir(DIR); # выбираем файлы ttys*  из каталога/dev/
 my @ComportParams = ();    #параметры com-порта
 
 foreach $file (@files)
 {
   if($file=~/ttyS(\d{1,3})/)
   {
     push(@ComportParams,["$1"+1,("$1"+1)." ($file)"]);
   }
 }
 closedir(DIR);
 return @ComportParams;
}
