#!/usr/bin/perl

require 'LoadKrugSettings.pl';
require 'parse_file-lib.pl';
require 'waitbox.pl';

use feature ":5.10";

use CGI::Lite;
$cgi = new CGI::Lite();
my %params = $cgi->parse_form_data();

my $chnum = $params{'chnum'};

my %settings = LoadKrugSettings();
my $interface = $settings{'GSW_GUICFG'} . 'tunnel/' . 'channelIface.config';
my %ifaceData = ParseInterfaceConfig($interface);
my %data = ParseIniFile();

my $cv_count = 0;

my $script =
	"<script language=javascript src='WaitBox.js'></script>" .
	"<script language=javascript src='validate.js'></script> \n" .
	'<meta http-equiv="Content-Type" content="text/html; charset=utf8">'
;
print ui_print_header(
	undef, "$text{'caption_channel'} " . $chnum, "", undef, undef, 1, undef,
	'<link rel="stylesheet" type="text/css" href="index_cgi.css" />', 
	$script
);

ShowWaitBox("$text{'data_prep'}", "none");

print '<div id="main_div" style="display:block;">';
print ui_form_start('channel_save.cgi', 'post');
print ui_hidden('redirect_param1', $chnum);
print ui_columns_start([$text{'table_param'}, $text{'table_value'}, '']);

foreach $control (sort keys %ifaceData) {
	#Сортируем элементы управления по порядку их появления в интерфейсе
	my %d = %{$ifaceData{$control}};
	foreach $param (sort {($d{$a}{'Order'} + 0) <=> ($d{$b}{'Order'} + 0)} keys %d) {
		my @cols = ();
		my $section = $d{$param}{'Section'};
		if ($section =~ /Options Channel/) {
			$section = "[$section]";
			$section =~ s/Channel/Channel$chnum/g;
			my $paramname = $d{$param}{'Param'};
			my $value     = $d{$param}{'DefValue'};

			if (defined($data{$section}{$paramname})) {
				$value = $data{$section}{$paramname};
			}
			$type = ($d{$param}{'Type'});
			my $control = ();
			my $edit_events = ();
			my $error_ctrl = ();
			given ($type) {
				when ("EditBox") {
					my $id = $paramname . $section;
					my $min = $d{$param}{'MinValue'};
					my $max = $d{$param}{'MaxValue'};
					$edit_events =
						"onchange=\"isValidDigit(event, this.id, this.value, '$min', '$max')\"" .
						' onkeydown="OnKeyDown(event)" onfocus="onFocus(event)" onkeyup="OnKeyUp(this.id)"';
					if ($min eq '') { $min = '-&infin;'; }
					if ($max eq '') { $max = '&infin;';	}
					$error_ctrl = 
						"<div class=\"err\" id=\"${id}_err\" style=\"display:none\"" . 
						' title="' . $text{'right_param'} . " $min..$max\">" . 
						"$text{'wrong_param'}</div>";
					$control = ui_textbox($id, $value, 40, 0, 6, "id=\"$id\" $edit_events");
					push(@cols, [$text{$d{$param}{'Caption'}}, $control, $error_ctrl]);
				}
				when ("DBVarBox") {
					my $id = $paramname . $section;
					my $min = $d{$param}{'MinValue'};
					my $max = $d{$param}{'MaxValue'};
					my $vtype = $d{$param}{'VarType'};
					my $var_num;
					
					if ($value =~ /(\S+)(\d+)/) {
						foreach my $i (keys %vtype_names) {
							if (($i eq lc($vtype)) 
								&& ($vtype_names{$i} eq uc($1))) {
								$var_num = $2;						
							}
						}
					} 

					$edit_events =
						"onchange=\"isValidDigit(event, this.id, this.value, '$min', '$max')\"" .
						' onkeydown="OnKeyDown(event)" onfocus="onFocus(event)" onkeyup="OnKeyUp(this.id)"';
					if ($min eq '') { $min = '-&infin;'; }
					if ($max eq '') { $max = '&infin;';	}
					$error_ctrl = 
						"<div class=\"err\" id=\"${id}_err\" style=\"display:none\"" . 
						' title="' . $text{'right_param'} . " $min..$max\">" . 
						"$text{'wrong_param'}</div>";
					$control = $text{'var_name_' . $vtype} . '' . ui_textbox($id, $var_num, 24, 0, 6, "id=\"$id\" $edit_events");
					push(@cols, [$text{$d{$param}{'Caption'}}, $control, $error_ctrl]);
				}
				when ("CompositeValue") {
					my $master_id = $paramname . $section;
					my $parts = $d{$param}{'Parts'};
					$cv_count++;
					print ui_hidden('cv' . $cv_count, $master_id);
					$error_ctrl = 
						'<div class="err" id="' . $master_id . '_err" style="display:none">' . 
						$text{'wrong_param'} . '</div>';

					$control = ui_columns_start();
					for (my $i=1; $i<=$parts; $i++) {
						my $part_name = $d{$param}{'ParamPart' . $i};
						my $id = $paramname . '_' . $part_name . $section;
						my @cc = ();
						my $checked = '';
						my $value_ctrl = ();

						if ($value =~ /\Q$part_name\E/) {
							$checked = 'checked';
						}					

						my $check_ctrl = 
							"<input class='ui_checkbox' type=checkbox " . $checked .
							" name='" . $id . "_ck' value='1'  id='" . $id . "_ck'" .
							' onclick="enable_composite_value('. "'" . $id . "'" . ', this.checked)">' .
							"<label for='" . $id . "_ck'>" . 
							$text{$d{$param}{'Caption' . $i}} . '</label>'
						;

						if ($d{$param}{'HasValue' . $i} == 1) {
							$edit_events = 'onfocus="onFocus(event)"';
							given (lc($d{$param}{'Validate' . $i})) {
								when ("digit") { 
									my $min = $d{$param}{'MinValue' . $i};
									my $max = $d{$param}{'MaxValue' . $i};
									$edit_events = 
										$edit_events . 
										" onchange=\"isValidDigit(event, this.id, this.value, '$min', '$max')\"" .
										' onkeydown="OnKeyDown(event)" onfocus="onFocus(event)" onkeyup="OnKeyUp(this.id)"';
									if ($min eq '') { $min = '-&infin;'; }
									if ($max eq '') { $max = '&infin;';	}
									$part_error_ctrl = 
										'<div class="err" id="' . $id . '_vl_err" style="display:none"' . 
										' title="' . $text{'right_param'} . " $min..$max\">" . 
										$text{'wrong_param'} . '</div>';
								}
								when ("schedule") { 
									$edit_events = 
										$edit_events . 
										" onchange=\"isValidSchedule(event, this.id, this.value)\"" .
										' onkeydown="OnKeyDownSched(event)" onfocus="onFocus(event)" onkeyup="OnKeyUp(this.id)"' .
										' style="text-transform: uppercase;"';
									$part_error_ctrl = 
										'<div class="err" id="' . $id . '_vl_err" style="display:none">' . 
										$text{'wrong_param'} . '</div>';
								}
							} 

							my @part_value = split('\+', $value);
							my $part_val = ();
							foreach my $v (@part_value) {
								if ($v =~ /\Q$part_name\E/) {
									$v =~ s/.*=(.*?)/$1/;
									$part_val = $v;
									last;
								}
							}
							
							my $vlen = 6;
							if (defined($d{$param}{'ValueLen' . $i})) {
								$vlen = $d{$param}{'ValueLen' . $i};
							}

							my $dis_box = 0;
							if ($checked eq '') {
								$dis_box = 1;
							}							
							$value_ctrl = ui_textbox($id . '_vl', $part_val, 35, $dis_box, $vlen, 'id="' . $id . '_vl" ' . $edit_events);
						}					
						push(@cc, [$check_ctrl, $value_ctrl, $part_error_ctrl]);					
						$control = $control . ui_columns_row(@cc);
					}
					$control = $control . ui_columns_end();
					
					push(@cols, [$text{$d{$param}{'Caption'}}, $control, $error_ctrl]);					
				}
			}
			print ui_columns_row(@cols);
		}
	}
	undef %d;
}
print ui_columns_end();

print ui_hidden('cv_count', $cv_count);

print '<p align="center">',
		ui_submit($text{'button_apply'}, "btnApply", 0,
			"onclick=\"validateFormParams(event, '$text{'data_save'}', '$text{'jst_valid_fail'}')\"");
print "</p>";

print ui_form_end();
print '</div>';
