#!/usr/bin/perl

require 'parse_file-lib.pl';
require 'waitbox.pl';

use CGI::Lite;
$cgi = new CGI::Lite();
my %params = $cgi->parse_form_data();

my $rparam1 = $params{'redirect_param1'};

my %data = ParseIniFile();
my %settings = LoadKrugSettings();
my $interface = $settings{'GSW_GUICFG'} . 'tunnel/' . 'channelIface.config';
my %ifaceData = GetIniFileData($interface);

# есть ли составные параметры в форме
if ($params{'cv_count'} > 0) {
	for (my $i=1; $i<=$params{'cv_count'}; $i++) {
		my $cv_param = $params{'cv'.$i};
		if ($cv_param =~ /(\S+)(\[.*\])/) {
			my $pname = $1;
			my $psec = $2;
			my $tmp_val;
			my $j = 0;
			# собираем значения составного параметра в единое целое
			foreach my $p (sort keys %params) {
				if ($p =~ /\Q$pname\E_(.*?)\Q$psec\E_(.*?)\b/) {
					if ($2 eq 'ck') {
						if ($j > 0) {
							$tmp_val = $tmp_val . '+';
						}
						$tmp_val = $tmp_val . $1;
						$j++; 											
					}
					if ($2 eq 'vl') {
						$tmp_val = $tmp_val . '=' . uc($params{$p});
					}
					delete $params{$p};
				}
			}
			$params{$cv_param} = $tmp_val;
		}
	}
}

#добавление имени переменной БД к заданному пользователю номеру.
foreach my $control (sort keys %ifaceData) {
	if ($ifaceData{$control}{'Type'} eq 'DBVarBox') {
		my $section = '[' . $ifaceData{$control}{'Section'} . $rparam1 . ']';
		my $param = $ifaceData{$control}{'Param'};
		my $super_name = $param . $section;
		if (length($params{$super_name}) != 0) {
			$params{$super_name} = $vtype_names{$ifaceData{$control}{'VarType'}} . $params{$super_name};
		}
	}
}

foreach $p (sort keys %params) {
	if ($p =~ /(\S+)(\[.*\])/) {
		my $ss = $2;
		my $pp = $1;
		$data{$ss}{$pp} = $params{$p};
		if ($data{$ss}{$pp} =~ /^0*(0|\d+)$/) {
			$data{$ss}{$pp} = $1;
		}
	}
}

Save(%data);

redirect("channel.cgi?chnum=$rparam1");
