#!/usr/bin/perl

require 'parse_file-lib.pl';
require 'waitbox.pl';

use Encode qw( from_to is_utf8 );

my %Data = ParseIniFile();
my $script =
	"<script language=javascript src='WaitBox.js'></script>\n" .
	"<script language=javascript src='channels.js'></script>\n" .
	'<meta http-equiv="Content-Type" content="text/html; charset=utf8">'
;

print ui_print_header(
	undef, $text{'caption_channels'}, "", undef, undef, 1,
	undef, '<link rel="stylesheet" type="text/css" href="index_cgi.css" />',
	$script
);

ShowWaitBox($text{'data_prep'}, "none");

print '<div id="main_div" style="display:block;">';
print ui_form_start('channels_add.cgi', "post");
print ui_columns_start([$text{'table_chid'}, $text{'table_chtype'} . "*", ""], "100%");

my %chnls = ();
foreach $section (keys %Data) {
	my $id = ();
	if ($section =~ /Options Channel\d{1,5}/) {
		$id = $section;
		$id =~ s/\[Options Channel(\d{1,5})\]/$1/g;
		if (!defined($chnls{$id})) {
			$chnls{$id}{'type_server'} = $Data{$section}{'type_connect_server'};
			$chnls{$id}{'type_client'} = $Data{$section}{'type_connect_client'};
		}
	}
}
foreach $section (sort keys %chnls) {
	my $link = "channel.cgi?chnum=$section";
	my $confirm_text = $text{'jst_ch_del'} . ' ' . $text{'caption_channel'} . ' ' . $section . '?';
	my $wb_text = $text{'data_del'} . ' ' . $text{'caption_channel'} . ' ' . $section . '...'; 
	my $btnscript = 'onclick="removechannel(event,' . "'$section','$confirm_text','$wb_text');\""; 
	my $removebtn = ui_button($text{'button_del'}, 'removebtn', 0, $btnscript);
	print ui_columns_row([
		"<a href=$link>$text{'caption_channel'} $section</a>",
		"$chnls{$section}{'type_client'}" . '-' . "$chnls{$section}{'type_server'}",
		$removebtn
	]);
}
print ui_columns_end();

my $editEvents = 'onkeydown="OnKeyDown(event)"';
my @Values     = ();
push(@Values, ['serial-serial', 'serial-serial']);
push(@Values, ['serial-tcp', 'serial-tcp']);

print '<table width="70%">';
print "<tr>";
print '<td width="10%">';
print "<b>$text{'text_add'}</b>";
print "</td>";
print '<td width="35%">';
print ui_textbox("AddChannelsCount", "", 3, 0, 3, "id='AddChannelsCount' $editEvents"),
		"  ", ui_select('chtype', "", [@Values], 1, 0);
print "</td>";
print '<td width="20%">';
print "<b>$text{'text_channels'} </b>";
print "</td>";
print '<td width="20%">';
print ui_submit(
	$text{'button_apply'}, "btnApply", 0, 
	"onclick=\"validate(event,'$text{'jst_ch_add1'}','$text{'jst_ch_add2'}')\""
);
print "</td>";
print "</tr>";
print "</table>";
print "$text{'note_chnls_type'}";
print ui_form_end();
print "</div>";
