#!/usr/bin/perl

require 'LoadKrugSettings.pl';
require 'parse_file-lib.pl';
require 'waitbox.pl';

use CGI::Lite;
$cgi = new CGI::Lite();
my %params = $cgi->parse_form_data();

my %Data = ParseIniFile();
my $chnum = GetUniqueChannelNumber();
my $script =
	"<script language=javascript src='tree.js'></script>\n" .
  	'<meta http-equiv="Content-Type" content="text/html; charset=utf8">'
;

print ui_print_header(
	undef, $text{'caption_channels'}, "", undef, undef, 1, undef,
	'<link rel="stylesheet" type="text/css" href="index_cgi.css" />',
	$script, undef
);

ShowWaitBox($text{'data_add'}, "block");

my $count = $params{'AddChannelsCount'};
my %settings = LoadKrugSettings();

for (my $i=0; $i<($count + 0); $i++) {
	my $chtype = $params{'chtype'};
	my $num = $i + $chnum;

	my $section1 = '[Options Channel' . ($num) . ']';
	if ($chtype =~ /(.*)-(.*)/) {
		$Data{$section1}{'type_connect_client'} = "$1";
		$Data{$section1}{'type_connect_server'} = "$2";
	}
	my $param = ();
	my $interface = $settings{'GSW_GUICFG'} . 'tunnel/' . 'channelIface.config';
	my %ifaceData = ParseInterfaceConfig($interface);
	%ifaceData = %{ $ifaceData{'[Options Channel]'} };
	foreach $param (sort keys %ifaceData) {
		$Data{$section1}{$param} = $ifaceData{$param}{'DefValue'};
	}
	
	my $type = $Data{$section1}{'type_connect_client'}; 
	my $section2 = '[Channel' . $num . ' ' . $type . ' client]';
	$interface = $settings{'GSW_GUICFG'} . 'tunnel/' . $type . 'Iface.config';
	%ifaceData = ParseInterfaceConfig($interface);
	%ifaceData = %{ $ifaceData{'[Channel ' . $type . ']'} };
	foreach $param (sort keys %ifaceData) {
		$Data{$section2}{$param} = $ifaceData{$param}{'DefValue'};
	}

	$type = $Data{$section1}{'type_connect_server'}; 
	my $section3 = '[Channel' . $num . ' ' . $Data{$section1}{'type_connect_server'} . ' server]';
	$interface = $settings{'GSW_GUICFG'} . 'tunnel/' . $type . 'Iface.config';
	%ifaceData = ParseInterfaceConfig($interface);
	%ifaceData = %{ $ifaceData{'[Channel ' . $type . ']'} };
	foreach $param (sort keys %ifaceData) {
		$Data{$section3}{$param} = $ifaceData{$param}{'DefValue'};
	}
}

$Data{'[General Options]'}{'quan_channels'} = GetChannelsCount(\%Data);

my $OUTFILE;
my $path = $settings{'GSW_SETTINGS'} . "tunnel_conf.ini";
open( OUTFILE, ">/tmp/tmpfile" ) or die print "sdfsdfsdfsdf";
foreach my $section ( keys %Data ) {
	my $s = $section;
	print OUTFILE $s, "\n";
	foreach my $param ( keys %{ $Data{$section} } ) {
		my $v = $Data{$section}{$param};
		my $p = $param;
		print OUTFILE $p, "=", $v, "\n";
	}
}
close(OUTFILE);
$out = `iconv -f utf-8 -t cp866 /tmp/tmpfile -o $path`;

print '<SCRIPT LANGUAGE="JavaScript">';
print 'updatetree();';
print 'document.location="channels.cgi"';
print '</SCRIPT>';
