BEGIN {
	push( @INC, ".." );
}

use WebminCore;
init_config();

#require 'GetCOMInterfaces.pl';
require 'LoadKrugSettings.pl';

#типы переменных БД СРВК
our %vtype_names = (
	'vd' => 'ВД',
	'dv' => 'ДВ',
	'av' => 'АВ',
	'va' => 'ВА',
	'rv' => 'РВ'
);

#сохранить данные в файл
# переаметры - хеш с пользовательскими данными
sub Save() {
	my (%userdata)   = @_;
	my %KrugSettings = LoadKrugSettings();
	my $path         = $KrugSettings{'GSW_SETTINGS'} . "tunnel_conf.ini";
	my %filedata     = ParseIniFile($path);
	foreach my $section ( keys %userdata ) {
		foreach my $param ( keys %{ $userdata{$section} } ) {
			$filedata{$section}{$param} = $userdata{$section}{$param};
		}
	}
	my $OUTFILE;
	open( OUTFILE, ">/tmp/tmpfile" ) or die print "sdfsdfsdfsdf";
	foreach my $section ( keys %filedata ) {
		my $s = $section;
		print OUTFILE $s, "\n";
		foreach my $param ( keys %{ $filedata{$section} } ) {
			my $v = $filedata{$section}{$param};
			my $p = $param;
			print OUTFILE $p, "=", $v, "\n";
		}
	}
	close(OUTFILE);
	$out = `iconv -f utf-8 -t cp866 /tmp/tmpfile -o $path`;
}

# считать данные из файла конфигураций
sub ParseIniFile() {
	my %KrugSettings = LoadKrugSettings();
	my $filename = $KrugSettings{"GSW_SETTINGS"} . "tunnel_conf.ini";
	my %data     = GetIniFileData($filename);
	return %data;
}

#чтение файлов конфигураций интерфейсов(interface.config)
sub ParseInterfaceConfig() {
	my ($filename1) = @_;
	my %Data = GetIniFileData($filename1);
	my %Return_Data;
	for my $section ( keys %Data ) {
		for my $param ( keys %{ $Data{$section} } ) {
			my $Sect = "[" . $Data{$section}{'Section'} . "]";
			my $Par  = $Data{$section}{'Param'};
			$Return_Data{$Sect}{$Par}{$param} = $Data{$section}{$param};
		}
	}
	return %Return_Data;
}

sub GetUniqueChannelNumber() {
	my %settings = LoadKrugSettings();
	my $path     = $settings{'GSW_SETTINGS'} . "tunnel_conf.ini";

	my %data = GetIniFileData($path);
	my @chnumbers;
	foreach $s (keys %data) {
		if ( $s =~ /Options Channel\d{1,5}/ ) {
			$s =~ s/\[Options Channel(\d{1,5})\]/$1/g;
			push(@chnumbers, $s);
		}
	}
	my @chnumbers1 = sort { $a <=> $b } @chnumbers;
	if (scalar(@chnumbers1) == 0) {
		return 1;
	} else {
		return ($chnumbers1[scalar(@chnumbers1) - 1] + 1);
	}
}

# парсер файлов конфигураций
sub GetIniFileData() {
	my ($filename) = @_;
	my $INIFILE;
	my $section;
	my %Data = ();
	$out = `iconv -f cp866 -t utf-8 $filename -o /tmp/tmpfile`;
	if (open(INIFILE, "</tmp/tmpfile") != 0) {
		while (<INIFILE>) {
			chomp;
			$_ =~ s/:.*//g;
			if (/\[.+?\]/) {
				$section = $_;
				$Data{$section} = undef;
			}
			if (/(\.*)=(\.*)/) {
				my $s = "$`";
				$s =~ s/:.*//g;
				my $s1 = "$'";
				$Data{$section}{$s} = $s1;
			}
		}
		close(INIFILE);
	}
	return %Data;
}

#sub GetChannelsCount() {
#	my %settings = LoadKrugSettings();
#	my $path  = $settings{'GSW_SETTINGS'} . "tunnel_conf.ini";
#	my $count = `cat $path | grep -E -c 'Options Channel[[:digit:]]{1,5}'`;
#	return $count;
#}

sub GetChannelsCount() {
	my ($Data) = @_;
	my $count = 0;
	foreach $s (keys %$Data) {
		if ($s =~ /Options Channel\d{1,5}/) {
			$count++;
		}
	}
	return $count;
}

1;
