BEGIN {
	push( @INC, ".." );
}

use Encode qw( from_to is_utf8 );
use WebminCore;

&init_config();

sub GetIniFileDataForTree() {
	my ($filename) = @_;
	my $INIFILE;
	my $section;
	my %Data = ();

	$Data{'General Options'} = 0;

	# загрузить файл конфигурации
	if (open(INIFILE, "<" . $filename) != 0 ) {
		my @splitSectionName = ();
		while (<INIFILE>) {
			chomp;
			$_ =~ s/:.*//g;
			if (/\[.+?\]/) {
				$section = $_;
				$section =~ s/(\[)|(\])//g;
				from_to( $section, "cp866", "utf8" );
				@splitSectionName = split( /\s/, $section );
			}
			
			if (/(\.*)=(\.*)/) {
				my $paramName = "$`";
				from_to( $paramName, "cp866", "utf8" );
				my $param_value = "$'";
				from_to( $param_value, "cp866", "utf8" );

				if ( $section =~ /General Options/ ) {
					if ( $paramName =~ /quan_channels/ ) {
						$Data{$section} = $param_value;
					}
				} elsif ( $section =~ /Channel\d{1,5} (serial|tcp) (server|client)/ ) {
					$Data{$splitSectionName[0]}{'content'}{$splitSectionName[2]}{'type'} = $splitSectionName[1];
				} elsif ( $section =~ /Options Channel\d{1,5}/ ) {
					if ( $paramName =~ /type_connect_server/ ) {
						$Data{$splitSectionName[1]}{$paramName} = $param_value;
					}
					if ( $paramName =~ /type_connect_client/ ) {
						$Data{$splitSectionName[1]}{$paramName} = $param_value;
					}
				}
			}
		}
		close(INIFILE);
	}
	
	return %Data;
}

#руссификация названия секций
sub TranslateCaption() {
	my ($sourceCaption) = @_;
	$sourceCaption =~ s/General Options/$text{'caption_genopt'}/g;
	$sourceCaption =~ s/Channel/$text{'caption_channel'} /g;
	$sourceCaption =~ s/client/$text{'caption_client'} /g;
	$sourceCaption =~ s/server/$text{'caption_server'} /g;
	return $sourceCaption;
}

# сортировка нод дерева
sub sort_node() {
	my ($keyword) = @_;
	$s = $a;
	$s =~ s/$keyword//g;
	$s1 = $b;
	$s1 =~ s/$keyword//g;
	( $s + 0 ) <=> ( $s1 + 0 );
}

#добавляет скрипт обработки нажатия левой кнопки мыши по
#имени ноды в дереве
sub GetOnClickScriptString() {
	my ($name1, $name2, $type) = @_;
	my $id;
	
	if ( $name1 =~ /Channels/ ) {
		return "channels.cgi";
	} elsif ($name1 =~ /Channel\d{1,5}/) {
		$id = $name1;
		$id =~ s/Channel(\d{1,5})/$1/g;
		return "channel.cgi?chnum=$id";
	} elsif (defined($type)) {
		$id = $name2;
		$id =~ s/Channel(\d{1,5})/$1/g;
		if ($type =~ /serial/) {
			return "serial.cgi?chnum=$id&elem=$name1";
		} elsif ($type =~ /tcp/) {
			return "tcp.cgi?chnum=$id&elem=$name1";
		}
	}
}

1;
