#!/usr/bin/perl
BEGIN {
	push( @INC, ".." );
}
require 'LoadKrugSettings.pl';
require 'parse_file-lib.pl';
require 'parser.pl';
require 'waitbox.pl';

use feature ":5.10";

use CGI::Lite;
$cgi = new CGI::Lite();
my %params = $cgi->parse_form_data();

my $chnum = $params{'chnum'};
my $elem = $params{'elem'};

my %settings = LoadKrugSettings();
my $interface = $settings{'GSW_GUICFG'} . 'tunnel/' . 'tcpIface.config';
my %ifaceData = ParseInterfaceConfig($interface);

my %data = ParseIniFile();
my $select_section = ();

foreach $section (sort keys %data) {
	if ($section =~ /Channel$chnum serial $elem/) {
		$select_section = $section;
		last;
	}
}

my $script =
	"<script language=javascript src='WaitBox.js'></script>" .
	"<script language=javascript src='validate.js'></script> \n" .
	'<meta http-equiv="Content-Type" content="text/html; charset=utf8">'
;
print ui_print_header(
	undef, "$text{'caption_channel'} $chnum : " . TranslateCaption($elem) . "(tcp)", "", 
	undef, undef, 1, undef,	'<link rel="stylesheet" type="text/css" href="index_cgi.css" />', 
	$script, 'onload="onLoadCheck()"'
);

ShowWaitBox($text{'data_prep'}, "none");

print '<div id="main_div" style="display:block;">';
print ui_form_start( 'tcp_save.cgi', 'post' );
print ui_hidden('redirect_param1', $chnum);
print ui_hidden('redirect_param2', $elem);
print ui_columns_start([$text{'table_param'}, $text{'table_value'}, '']);

foreach $control (sort keys %ifaceData) {
	#Сортируем элементы управления по порядку их появления в интерфейсе
	my %d = %{$ifaceData{$control}};
	foreach $param (sort {($d{$a}{'Order'} + 0) <=> ($d{$b}{'Order'} + 0)} keys %d) {
		my @cols = ();
		my $section = $d{$param}{'Section'};
		if ($section =~ /Channel tcp/) {
			$section = "[$section $elem]";
			$section =~ s/Channel/Channel$chnum/g;
			my $paramname = $d{$param}{'Param'};
			my $value     = $d{$param}{'DefValue'};

			if (defined($data{$section}{$paramname})) {
				$value = $data{$section}{$paramname};
			}
			$type = ($d{$param}{'Type'});
			my $control = ();
			my $edit_events = ();
			my $error_ctrl = ();
			given ($type) {
				when ("EditBox") {
					my $id = $paramname . $section;
					my $min = $d{$param}{'MinValue'};
					my $max = $d{$param}{'MaxValue'};
					$edit_events =
						"onchange=\"isValidDigit(event, this.id, this.value, $min, $max)\"" .
						' onkeydown="OnKeyDown(event)" onfocus="onFocus(event)" onkeyup="OnKeyUp(this.id)"';
					if ($min eq '') { $min = '-&infin;'; }
					if ($max eq '') { $max = '&infin;';	}
					$error_ctrl = 
						"<div class=\"err\" id=\"${id}_err\" style=\"display:none\"" . 
						' title="' . $text{'right_param'} . " $min..$max\">" . 
						"$text{'wrong_param'}</div>";
					$control = ui_textbox($id, $value, 40, 0, 6, "id=\"$id\" $edit_events");
					push(@cols, [$text{$d{$param}{'Caption'}}, $control, $error_ctrl]);
				}
				when ("ComboBox") {
					my @tmpvalues = split(/\,/, $d{$param}{'Values'});
					my @values = ();
					foreach $val (@tmpvalues) {
						push(@values, [$val, $val]);
					}
					undef @tmpvalues;
					$control = ui_select($paramname . $section, $value, [@values], 1, 0);
					push(@cols,	[ html_escape( $text{$d{$param}{'Caption'}} ),
								$control, $error_ctrl]
					);
					undef @values;
					undef $control;
				}
			}
			print ui_columns_row(@cols);
		}
	}
	undef %d;
}
print ui_columns_end();

print '<p align="center">',
		ui_submit($text{'button_apply'}, "btnApply", 0, 
			"onclick=\"validateFormParams(event, '$text{'data_save'}', '$text{'jst_valid_fail'}')\"");
print "</p>";

print ui_form_end();
print '</div>';
