#!/usr/bin/perl

require 'LoadKrugSettings.pl';
require 'parser.pl';

my $script = "<script language=javascript src=\"tree.js\"></script>\n" .
             "<script language=javascript src=\"WaitBox.js\"></script>\n" .
             "<script language=javascript src=\"preventSelection.js\"></script>\n" .
             '<meta http-equiv="Content-Type" content="text/html; charset=utf8">';

print ui_print_header(
	undef, $text{'main_title'}, "", undef, undef, 1, undef,
	'<link rel="stylesheet" type="text/css" href="index_cgi.css" />',
	$script, 'onload="preventSelection(document);"'
);

print "<script language=\"JavaScript\">CreateWaitBox('$text{'jst_build_tree'}')</script>";

print ui_form_start('submit.cgi', 'post', undef);
BuildInterface();
print '<script language="JavaScript">';
print "var elem=document.getElementById('progress'); if (elem) {elem.style.display='none';}";
print '</script>';
print ui_form_end();

sub BuildInterface() {
	my %KrugSettings = LoadKrugSettings();
	my $IniFile      = $KrugSettings{'GSW_SETTINGS'} . "tunnel_conf.ini";
	my %Data         = GetIniFileDataForTree($IniFile);
	my $sizeofData   = scalar(keys %Data);
	my $chnls        = $Data{'General Options'};
		
	# отобразить дерево
	print '<div id="ROOT" class="Display_none">';
	
	print '<div><div>';
	print '<img src="images/treeicons/ftv2mlastnode.gif" style="vertical-align:top"',
			" onclick=\"onExpandButtonclick(event,'Channels',1)\">";
	my $scriptString = GetOnClickScriptString('Channels');
	print "<a href=$scriptString target=\"MainFrm\"",
			" onclick=\"onTextClick(event, '$text{'jst_refresh_info'}');\">",
			$text{'caption_channels'},
			"</a></div>";
	print '<div id="Channels">';
	
	if ($chnls == 0) {
		return;
	}
	
	my $k;
	foreach $sec1 (sort {sort_node("Channel")} keys %Data) {
		unless ( $sec1 =~ /Channel\d{1,5}/ ) {
			$k++;
			next;
		}
		
		print '<div><div>';
		print '<img src="images/treeicons/ftv2blank.gif" style="vertical-align:top">';
			
		if ($k == ($sizeofData - 1)) {
			print '<img src="images/treeicons/ftv2plastnode.gif" style="vertical-align:top"',
					' onclick="onExpandButtonclick(event,',
					"'$sec1'",
					',1)">';
		} else {
			print '<img src="images/treeicons/ftv2pnode.gif" style="vertical-align:top"',
					' onclick="onExpandButtonclick(event,',
					"'$sec1'",
					',0)">';
		}
		
		$scriptString = GetOnClickScriptString($sec1);
		print "<a href=$scriptString target=\"MainFrm\"",
				" onclick=\"onTextClick(event, '$text{'jst_refresh_info'}');\">",
				TranslateCaption($sec1),
				"</a></div>";

		my $i = 0;
		print '<div id="', $sec1, '" style="display:none;">';
		foreach $sec2 (keys %{ $Data{$sec1}{'content'} }) {
			print '<div><div>';
			print '<img src="images/treeicons/ftv2blank.gif" style="vertical-align:top">';
			
			my $sizeofData1 = scalar(keys %{ $Data{$sec1}{'content'} });
			if ($sizeofData == (1 + 0)) {
				print '<img src="images/treeicons/emptynode.gif" style="vertical-align:top">';
			} else {
				if ($k != ($sizeofData - 1)) {
					print '<img src="images/treeicons/ftv2vertline.gif" style="vertical-align:top">';
				} else {
					print '<img src="images/treeicons/emptynode.gif" style="vertical-align:top">';
				}
			}
			if ($i == ($sizeofData1 - 1)) {
				print '<img src="images/treeicons/ftv2lastnode.gif" style="vertical-align:top"',
						' onclick="onExpandButtonclick(event,',
						"'$sec1.$sec2'",
						',1)">';
			} else {
				print '<img src="images/treeicons/ftv2node.gif" style="vertical-align:top"',
						' onclick="onExpandButtonclick(event,',
						"'$sec1.$sec2'",
						',0)">';
			}

			$scriptString = GetOnClickScriptString($sec2, $sec1, $Data{$sec1}{'content'}{$sec2}{'type'});
			print "<a href=$scriptString target=\"MainFrm\"",
					" onclick=\"onTextClick(event, '$text{'jst_refresh_info'}');\">",
					TranslateCaption($sec2),
					"($Data{$sec1}{'content'}{$sec2}{'type'})",
					'</a></div>';
			$i++;
			print '</div>';
		}				
		$k++;
		print "</div></div>\r";
	}
	print '</div></div>';
}
