function fireEvent(element, event){
	if (document.createEventObject) {
		// dispatch for IE
		var evt = document.createEventObject();
		return element.fireEvent('on'+event,evt)
	} else {
		// dispatch for firefox + others
		var evt = document.createEvent("HTMLEvents");
		evt.initEvent(event, true, true ); // event type,bubbling,cancelable
		return !element.dispatchEvent(evt);
	}
}

function onLoadCheck() {
	for (var i=0; i<document.forms[0].elements.length; i++) {
		fireEvent(document.forms[0].elements[i], 'change');
	}
}

function validateFormParams(event, text_ok, text_fail) {
	var e = event || window.event;
	for (var i=0; i<document.forms[0].elements.length; i++) {
		var elem_id = document.forms[0].elements[i].id + "_err";
		var elem = document.getElementById(elem_id);
		if (elem != null) {
			if (elem.style.display == "block") {
				alert(text_fail)
				if (typeof e.preventDefault != 'undefined') {
					e.preventDefault();
				} else {
					e.returnValue = false;
				}
				return;
			}
		}
	}
	ShowWaitBox(text_ok);
}

function isValidDigit(event, id, value, min, max) {
	var e = event || window.event;
	e.returnValue = true;
	var digit_reg = /^[0-9]+$/;
	var el = document.getElementById(id+"_err");
	if (!value.match(digit_reg)) {
		el.style.display = "block";
		return false;
	} else {
		if (min != '') {
			if ((value == "") || (value < parseInt(min))) {
				el.style.display = "block";
				return false;
			}
		} 
		if (max != '') {
			if ((value == "") || (value > parseInt(max))) {
				el.style.display = "block";
				return false;
			}
		}
	}
	el.style.display = "none";
	return true;
}

function isValidSchedule(event, id, value) {
	var e = event || window.event;
	e.returnValue = true;
	var sched_reg = /^\s*<(XX|\d\d)\/(XX|\d\d)\/(XX|\d\d|\d\d\d\d)\s+(XX|\d\d)\.(XX|\d\d)\.(XX|\d\d)>\s*$/i;
	var el = document.getElementById(id+"_err");
	if (!value.match(sched_reg)) {
		el.style.display = "block";
		return false;
	}
	el.style.display = "none";
	return true;
}

function hideErors(event) {
	var e = event || window.event;
	e.returnValue = true;
	for (i = 0; i < document.forms[0].elements.length; i++) {
		if (document.forms[0].elements[i].type == "text") {
			var name = document.forms[0].elements[i].name;
			var reg = /_err/;
			var result = reg.test(name);
			if (result) {
				document.forms[0].elements[i].style.visibility = "hidden";
			}
		}
	}
}

function OnKeyDownSched(event) {
	var code;
	var e = event || window.event;
	if (e.keyCode)
		code = e.keyCode;
	else if (e.keyCode)
		code = e.keyCode;
	if (((code > 95) && (code < 106))
		|| ((!e.shiftKey) && (code > 47) && (code < 58))
		|| (code == 8) || (code == 37) || (code == 39) || (code == 46)
		|| (code == 9) || (code == 45) || (code == 36) || (code == 35) 
		|| ((e.shiftKey) && (code == 188)) 
		|| ((e.shiftKey) && (code == 190))
		|| (code == 190) || (code == 191) || (code == 32) || (code == 88)
		|| ((e.ctrlKey) && (code == 67)) 
		|| ((e.ctrlKey) && (code == 86))) {
		e.returnValue = true;
	} else {
		if (typeof e.preventDefault != 'undefined') {
			e.preventDefault();
		} else {
			e.returnValue = false;
		}
	}
};

function OnKeyUp(id) {
	fireEvent(document.getElementById(id), 'change');
}

function OnKeyDown(event) {
	var code;
	var e = event || window.event;
	if (e.keyCode)
		code = e.keyCode;
	else if (e.keyCode)
		code = e.keyCode;
	if (((code > 95) && (code < 106))
		|| ((!e.shiftKey) && (code > 47) && (code < 58))
		|| (code == 8) || (code == 37) || (code == 39) 
		|| (code == 46) || (code == 9) || (code == 45)
		|| (code == 36) || (code == 35)
		|| ((e.ctrlKey) && (code == 67)) 
		|| ((e.ctrlKey) && (code == 86))) {
		e.returnValue = true;
	} else {
		if (typeof e.preventDefault != 'undefined') {
			e.preventDefault();
		} else {
			e.returnValue = false;
		}
	}
};
function onFocus(event) {
	var e = event || window.event;
	e.returnValue = true;
	var curelem = document.activeElement;
	curelem.style.color = "black";
}

function enable_composite_value(id, status)
{
	var el_val = document.getElementById(id+"_vl");
	if (el_val != null) {
		var el_val_err = document.getElementById(id+"_vl_err");
		status=!status;	
		el_val.disabled = status;
		if (!status) {
			fireEvent(el_val, 'change');
		} else {
			el_val_err.style.display = "none";	
		}
	}
}
