use WebminCore;
init_config();

sub GetEthIfaces()
{
 my $path = '/gsw/etc/ifaces';
 my %data;
 my $cureth;
 if(!defined(open( INIFILE, "<" . $path ))) 
 {
      $data{'eth0'}{'address'} = '192.168.10.248';
      $data{'eth0'}{'netmask'} = '255.255.255.0';
      $data{'eth0'}{'gateway'} = '192.168.10.1';
      return %data;
 }
   while (<INIFILE>)
   {
    chomp;
    $_ =~ s/#.*//g;
    if (/iface (eth\d{1,3}(?!:\d{1,3})) inet static/)
    {
     $cureth = "$1";
     $data{"$1"} = undef;
    }    
    if(/iface (eth\d{1,3}(?!:\d{1,3})) inet dhcp/)
    {
     $cureth = "$1";
     $data{"$1"} = undef;
     $data{$cureth}{'address'} = '192.168.10.248';
     $data{$cureth}{'netmask'} = '255.255.255.0';
     $data{$cureth}{'gateway'} = '192.168.10.1';
     $data{$cureth}{'fldhcp'} = "dhcp";
     next;  	
    }
    if (/(address|netmask|broadcast|network|gateway)\s{1}(\S+)/)
    {
     $param                 = "$1";
     $value                 = "$2";
     if(!defined($data{$cureth}{$param}))
     {
      $data{$cureth}{$param} = $value;
     }
    }
 }
 close(INIFILE);
 return %data;
}
