BEGIN { push(@INC,".."); 
push(@INC,"/usr/libexec/webmin/net","/usr/lib/perl5/5.8.8/Tie","/usr/share/webmin/net");
};
use Switch;
use WebminCore;
require 'net-lib.pl';
init_config();
use Tie::IxHash;
use Encode qw( from_to is_utf8 ); 
sub GetEnabledServices()
{
   my %settings = LoadKrugSettings();
   my $services_ini = $settings{'GSW_SETTINGS'}.'services.ini';
   my $init_d_path=$settings{'GSW_ETC'}.'/rc.d/init.d/';
   my %services_data=GetIniFileData($services_ini);
   my %data=();
   foreach my $s (keys %services_data)
   {
      my $filepath=$init_d_path.$services_data{$s}{'processname'}; 
      system("ls ".$filepath);
      if($?!=0)
      {
         delete $services_data{$s};
      }                 
   }        

   return %services_data;
}
sub GetServicesStatuses()
{
   my %services_data=@_;
   my %settings = LoadKrugSettings();
   my $rc1_path=$settings{'GSW_ETC'}.'rc.d/rc1.d/';
   my $rc0_path=$settings{'GSW_ETC'}.'rc.d/rc0.d/';
   my $rc6_path=$settings{'GSW_ETC'}.'rc.d/rc6.d/';
   my $init_d_path=$settings{'GSW_ETC'}.'rc.d/init.d/';
   foreach my $s (keys %services_data)
   {
      #запускается ли процесс в режиме программирования      
      my $startFileName="S".$services_data{$s}{'order'}.$services_data{$s}{'processname'};
      my $killFileName;
      if((100-$services_data{$s}{'order'})<(10-0))
      {
        my $tmp="0".(100-$services_data{$s}{'order'});        
        $killFileName="K".$tmp.$services_data{$s}{'processname'};        
      }
      else
      {      
         my $tmp=(100-$services_data{$s}{'order'});
        $killFileName="K".$tmp.$services_data{$s}{'processname'};
      }

      my $filepath=$rc1_path.$startFileName;
      system("ls ".$filepath);
      if($?==0)
      {
         $services_data{$s}{"startprogmode"}=1;
      } 
      else
      {        
         if($services_data{$s}{'required'}=~/(true)|(\d)/)
         {
            
            if($services_data{$s}{"startprogmode"}==1)
            {
              switch ($services_data{$s}{'required'})
              {
              	case "0"
              	{
                  system("ln -s -f ".$init_d_path.$services_data{$s}{'processname'}." ".$rc1_path.$startFileName);
                 system("ln -s -f ".$init_d_path.$services_data{$s}{'processname'}." ".$rc6_path.$killFileName);              		             		
              	}
              	case "1"
              	{
                 system("ln -s -f ".$init_d_path.$services_data{$s}{'processname'}." ".$rc1_path.$startFileName);
                 system("ln -s -f ".$init_d_path.$services_data{$s}{'processname'}." ".$rc6_path.$killFileName);              		              		
              	}
              	case "true"
              	{
                 system("ln -s -f ".$init_d_path.$services_data{$s}{'processname'}." ".$rc1_path.$startFileName);
                 system("ln -s -f ".$init_d_path.$services_data{$s}{'processname'}." ".$rc6_path.$killFileName);              		
              	}
              	else
              	{
                   $services_data{$s}{"startprogmode"}=0;
              	}
              }
            }
         } else
         {
            $services_data{$s}{"startprogmode"}=0;
         }                
      }                 
      #запускается ли файл в режиме основной работы
      $filepath=$rc0_path.$startFileName;
      system("ls ".$filepath);
      if($?==0)
      {
         $services_data{$s}{"startrunmode"}=1;
      } 
      else
      {
         if($services_data{$s}{'required'}=~/(true)|(\d)/)
         {
            if($services_data{$s}{"startrunmode"}==1)
            {
              switch ($services_data{$s}{'required'})
            {
              	case "0"
              	{
                 system("ln -s -f ".$init_d_path.$services_data{$s}{'processname'}." ".$rc0_path.$startFileName);
                 system("ln -s -f ".$init_d_path.$services_data{$s}{'processname'}." ".$rc6_path.$killFileName);              		              		
              	}
              	case "2"
              	{
                 system("ln -s -f ".$init_d_path.$services_data{$s}{'processname'}." ".$rc0_path.$startFileName);
                 system("ln -s -f ".$init_d_path.$services_data{$s}{'processname'}." ".$rc6_path.$killFileName);              		              		
              	}
              	case "true"
              	{
                 system("ln -s -f ".$init_d_path.$services_data{$s}{'processname'}." ".$rc0_path.$startFileName);
                 system("ln -s -f ".$init_d_path.$services_data{$s}{'processname'}." ".$rc6_path.$killFileName);              		
              	}
              	else{ $services_data{$s}{"startrunmode"}=0;}
            }
            }
         }else                 
         {
            $services_data{$s}{"startrunmode"}=0;
         }                
      }
   }    
   return %services_data;    
}
sub SortServicesByOrder()
{
   my (%services_data)=@_;
   my %retData=();   
   foreach my $s (keys %services_data)
   {
    $retData{$services_data{$s}{'order'}}{'shortname'} = $services_data{$s}{'shortname'};   
    $retData{$services_data{$s}{'order'}}{'description'} = $services_data{$s}{'description'};   
    $retData{$services_data{$s}{'order'}}{'processname'} = $services_data{$s}{'processname'};   
    $retData{$services_data{$s}{'order'}}{'category'} = $services_data{$s}{'category'};   
    $retData{$services_data{$s}{'order'}}{'startprogmode'} = $services_data{$s}{'startprogmode'};   
    $retData{$services_data{$s}{'order'}}{'startrunmode'} = $services_data{$s}{'startrunmode'};   
    $retData{$services_data{$s}{'order'}}{'required'} = $services_data{$s}{'required'};   
   }   
   return %retData;
}
sub SortServicesByName()
{
   my %retData=();
   my %services_data=@_;
   
   foreach my $s (keys %services_data)
   {
    $retData{$services_data{$s}{'processname'}}{'shortname'} = $services_data{$s}{'shortname'};   
    $retData{$services_data{$s}{'processname'}}{'description'} = $services_data{$s}{'description'};   
    $retData{$services_data{$s}{'processname'}}{'order'} = $services_data{$s}{'order'};   
    $retData{$services_data{$s}{'processname'}}{'category'} = $services_data{$s}{'category'};   
    $retData{$services_data{$s}{'processname'}}{'startprogmode'} = $services_data{$s}{'startprogmode'};   
    $retData{$services_data{$s}{'processname'}}{'startrunmode'} = $services_data{$s}{'startrunmode'};   
    $retData{$services_data{$s}{'processname'}}{'required'} = $services_data{$s}{'required'};   
   }   
   return %retData;
}
sub LoadKrugSettings()
{
  my @output = `cat /gsw/etc/krug.env`;
  my %data = ();
  foreach $s (@output)
  {
    chomp ($s);
    $_ = $s;
    if(/(\.*)\=(\.*)/)
    {
        my $tmp = "$'";
        $data{"$`"}=$tmp; 
    }
  }
  return %data;
}
# парсер файлов конфигураций
sub GetIniFileData()
{ 
 my ($filename) = @_;
 my $INIFILE;
 my $section;
 tie %Data, "Tie::IxHash";
 if(open(INIFILE, "<".$filename)!=0) 
 {
 while(<INIFILE>)
 {
   chomp;
   $_=~s/:.*//g;    

   if(/\[.+?\]/)  
   {     
     $section = $_;
     from_to($section,"cp866","utf8");
   }
   if(/(\.*)\=(\.*)/)
   {  
     $s ="$`";    
     $s=~s/:.*//g;
     from_to($s,"cp866","utf8");
     my $s1="$'";
     from_to($s1,"cp866","utf8");   
     $Data{$section}{$s} = $s1;  
   }  
 }
 close(INIFILE);
 } 
 return %Data;   
}
