#!/usr/bin/perl
require './parse_file-lib.pl';
require '../waitbox.pl';
use Encode qw( from_to is_utf8 ); 
use WebminCore;
init_config();
my %settings  = LoadKrugSettings();
#my $o=`mkdir -p /tmp/krugdb_internal`;

my $script = "<script language=javascript src='./trends.js'> </script>"."\n".
             "<script language=javascript src='../WaitBox.js'> </script>"."\n".
'<meta http-equiv="Content-Type" content="text/html"; charset="utf8">';
print ui_print_header(undef,"Задание текстовых идентификаторов и очистка архивов",undef,undef,1,1,undef,undef,$script,undef);
if(IsSupport()!=1)
{
print <<EOF
   <p align="center">
    <font color="red"><b>Для работы данного плагина необходимо установить пакет СРВК Devlink версии 7.16 SP6 или выше</b></font> 
  </p>
EOF
;
	exit;
}
ShowWaitBox("Выполняется обработка данных...",'none');
my %Data=ParseIniFile();
print ui_form_start('SaveData.cgi','post');

print '<div id="main_div">';
print &ui_columns_start(["Архивы контроллера","Очистка"],70,0,undef);
print &ui_columns_row([ui_textbox("Global_name",
                      $Data{'[Global]'}{'ArchiveName'}),
                      '<p style="padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;" align="center"><img src="./clear.gif" onclick="_clear_(event,-1,-1)"></img></p>'],0);
print &ui_columns_end(),'<p></p>';

  print &ui_columns_start(["ID","Самописец","Очистка"],70,0,undef);
my $i=0;  
foreach my $s (sort {$Data{$a}{'ID'}<=>$Data{$b}{'ID'}}keys %Data)
{
if($s=~/Global/)
{
	next;
}
else
{
  my $pentable= '<Div style="position:relative ; width:90%; display:none" id=smp'.$Data{$s}{'ID'}.' >';
  $pentable=$pentable.&ui_columns_start(["ID","Перо","Очистка"],50,0,undef);
   my $j=0;
   foreach $param (sort{$Data{$s}{$a}{'id'}<=>$Data{$s}{$b}{'id'}}keys %{$Data{$s}})
   {
   	  if($param=~/Pen\d{1,5}/)
   	  {        
        $pentable=$pentable.ui_columns_row(
           [$Data{$s}{$param}{'id'},
            ui_textbox($s."_".$param."_Name",$Data{$s}{$param}{'name'},29,0,29),
            '<p style="padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;" align="center"><img src="./clear.gif" onclick="_clear_(event,'.$Data{$s}{$param}{'id'}.','.$Data{$s}{'ID'}.')"></img></p>'],['style="padding-bottom: 0px;padding-top: 0px;"','style="padding-bottom: 0px;padding-top: 0px;"','style="padding-bottom: 0px;padding-top: 0px;"'],($j+0)%2);
            $j++;  	
   	  }
   	  next; 
   } 
  $pentable=$pentable.&ui_columns_end();
  $pentable=$pentable.'</Div>';

  print &ui_columns_row(['<b>'.$Data{$s}{'ID'}.'</b>',
                         "Имя самописца".ui_textbox($s."_Name",
                         $Data{$s}{'Name'},29,0,29).ui_button("Показать перья",undef,0,'onclick="ShowAdvanced(event'.",'smp".$Data{$s}{'ID'}."'".')"').$pentable,
                         '<p style="padding-bottom: 0px;padding-top: 0px;margin-top: 0px;margin-bottom: 0px;" align="center"><img src="./clear_large.gif" onclick="_clear_(event,'.'-1,'.$Data{$s}{'ID'}.')"></img></p>'],undef,($i+0)%2);

}	
  $i++;                         	
}
print &ui_columns_end();
print '<p align="center">'.ui_submit("Применить","submit_btn",0,"onclick=\"ShowWaitBox()\"")."</p>";
print ui_form_end();
print '</div">';

sub Get_srvk_version()
{
 my ($filename) = @_;
 my $INIFILE;
 my $section;
 my %Data;
 $filename="/gsw/rep/packages.ini";
 if(open(INIFILE, "<".$filename)!=0) 
 {
 while(<INIFILE>)
 {
   chomp;
   $_=~s/:.*//g;    

   if(/\[.+?\]/)  
   {     
     $section = $_;
     from_to($section,"cp866","utf8");
   }
   if(/(\.*)\=(\.*)/)
   {  
     $s ="$`";    
     $s=~s/:.*//g;
     from_to($s,"cp866","utf8");
     my $s1="$'";
     from_to($s1,"cp866","utf8");   
     $Data{$section}{$s} = $s1;  
     undef $s;
     undef $s1;
   }  
 }
 close(INIFILE);
 } 
 undef $section;
 undef $INIFILE;
 undef $filename;
 my $version=-1;
 foreach $package(keys %Data)
 {
 	if($Data{$package}{'PackageName'}=~/-srvk/)
 	{
      $version=$Data{$package}{'Version'};
      last; 		
 	}
 }
 
 return $version;   	
}
sub IsSupport()
{
  my $res=1;
  my $packageName=`fw_printenv bpkg|sed -r "s/bpkg=//g"`;
  
  for($i=0;$i<5;$i++)
  {
    $packageName=`fw_printenv bpkg|sed -r "s/bpkg=//g"`;
    if(length($packageName)==0)
    {
    sleep(1);
    }
    else
    {
      last;
    }
  }
  chop $packageName;
  $packageName=~s/bpkg=//g;
  #Не получилось взять имя пакета СРВК из fv_printenv
  if(length($packageName)==0)
  {
  	my $version=Get_srvk_version();
  	my $ver_compare_result= Compare_Versions($version,"7.16.6");	
    if ($ver_compare_result==-1)#version <7.16.6
    {
  	  $res=0;
  	  return $res;
    }  	
  }
  else
  {
    my $output=`dpkg -p $packageName |grep Version:|sed -r "s/Version:\\s+//g"|sed -r "s/\\.//g"`;
    $ver_compare_result= Compare_Versions($output,"7.16.6");
    if (($ver_compare_result==-1) && (length($packageName)>0)) #version <7.16.6
    {
  	 $res=0;
    }  
  }
  return $res;	
}
sub Compare_Versions()
{
 (my $left,my $right)=@_;
  my @l=split(/\./,$left);
  my @r=split(/\./,$right);
  
  if(scalar(@l)>scalar(@r))
  {
  	for($i=0;$i<(scalar(@l)-scalar(@r));$i++)
  	{
  		push(@r,"0");
  	}
  }
  if(scalar(@r)>scalar(@l))
  {
  	for($i=0;$i<(scalar(@r)-scalar(@l));$i++)
  	{
  		push(@l,"0");
  	}  	
  }
  my $result;
 for ($i=0;$i<scalar(@l);$i++)
 {
    if($l[$i]>$r[$i])
    {
      $result=1;
      return $result;	
    } else
    {
	    if($l[$i]==$r[$i])
	    {
	      $result=0;
	    }
	    else
	    {
		    if($l[$i]<$r[$i])
		    {
		      $result=-1;
		      return $result;	
		    }	    	
	    }    	
    } 	
 } 
 return $result;	
}