#!/usr/bin/perl
require '../waitbox.pl';
require './parse_file-lib.pl';
use Encode qw( from_to is_utf8 ); 
use WebminCore;
init_config();
my $script = "<script language=javascript src='./datetimepicker_css.js'> </script>"."\n".
             "<script language=javascript src='./trends_rep.js'> </script>"."\n".
'<meta http-equiv="Content-Type" content="text/html"; charset="utf8">';
print ui_print_header(undef,"Формирование отчёта архивных данных",undef,undef,1,1,undef,undef,$script,undef);
if(IsSupport()!=1)
{
print <<EOF
   <p align="center">
    <font color="red"><b>Для работы данного плагина необходимо установить пакет СРВК Devlink версии 7.16 SP6 или выше</b></font> 
  </p>
EOF
;
	exit;
}
print ui_form_start('makereport.cgi','post');
my $ed_begindate=();
my $chk_achBegin=();
my $ed_enddate=();
my $chk_curdate=();
my $chk_include_trends_param_in_report=();
my $btn_selectAll=();
my $bnt_unselectAll=();
my $PenTable=();
my $btn_makeReport=();
my $hdn_enddateutc=();
my $hdn_begindateutc=();
$ed_begindate=ui_textbox("BeginData","",20,0,50,"id=\"BeginData\"  readonly")."<img src=\"images2/cal.gif\" onclick=\"NewCssCal('BeginData','ddMMyyyy','dropdown',true,'24',true); document.getElementById('flStartArchive_1').checked=false;\" style=\"cursor:pointer\"/>";
$hdn_begindateutc=ui_hidden('BeginDataUTC','');
$chk_achBegin=ui_checkbox("flStartArchive",1,"Начало архивов",0,"onclick=\"setStartDate(event)\"");
$ed_enddate=ui_textbox("EndData","",20,0,50,"id=\"EndData\"  readonly")."<img src=\"images2/cal.gif\" onclick=\"NewCssCal('EndData','ddMMyyyy','dropdown',true,'24',true);document.getElementById('flCurrentData_1').checked=false;\" style=\"cursor:pointer\"/>";
$hdn_enddateutc=ui_hidden('EndDataUTC','');
$chk_curdate=ui_checkbox("flCurrentData",1,"Текущая",0,"onclick=\"setCurrentDate(event)\"");
$chk_include_trends_param_in_report=ui_checkbox("flTrendSettings",1,"Включить в отчёт настройки трендов");
$btn_selectAll=ui_button("Выделить всё","selectall",0,"onclick=\"selectAll(1)\"");
$bnt_unselectAll=ui_button("Снять выделение","unSelectAll",0,"onclick=\"unselect()\"");
$btn_makeReport=ui_submit("Сформировать","",0,"onclick=\"Validate(event);\"");
$PenTable=ui_columns_start(["ID","Самописец","Выбор"],50);
%Data=ParseIniFile();
foreach $s (sort{$Data{$a}{'ID'}<=>$Data{$b}{'ID'}}keys %Data)
{
  $_=$s;
  if(/Plotter\s(\d{1,5})/)
  {
  	 $PenTable=$PenTable.ui_columns_row([
  	                                    $Data{$s}{'ID'},
  	                                    $Data{$s}{'Name'},
  	                                    ui_checkbox("smp".$Data{$s}{'ID'},1,"",$Data{$s}{'Status'},"id=\"smp$Data{$s}{'ID'}\"")
  	                ]);
  }	
}
$PenTable=$PenTable.ui_columns_end();
print <<PETE; 
<table>
<tr>
  <td>
    Дата начала отчёта
  </td>
  <td>
  $ed_begindate $hdn_begindateutc<br>
  $chk_achBegin   
  </td>
</tr> 
<tr>
  <td>
    Дата окончания отчёта
  </td>
  <td>
   $ed_enddate $hdn_enddateutc<br>
   $chk_curdate
  </td>
</tr> 

</table>
<p align="left">$chk_include_trends_param_in_report </p>
<p align="center">Включить самописцы в отчёт:</p>
<p align="center">$btn_selectAll $bnt_unselectAll</p>
<p align="center">$PenTable $btn_makeReport</p>
PETE
print ui_form_end();


sub Get_srvk_version()
{
 my ($filename) = @_;
 my $INIFILE;
 my $section;
 my %Data;
 $filename="/gsw/rep/packages.ini";
 if(open(INIFILE, "<".$filename)!=0) 
 {
 while(<INIFILE>)
 {
   chomp;
   $_=~s/:.*//g;    

   if(/\[.+?\]/)  
   {     
     $section = $_;
     from_to($section,"cp866","utf8");
   }
   if(/(\.*)\=(\.*)/)
   {  
     $s ="$`";    
     $s=~s/:.*//g;
     from_to($s,"cp866","utf8");
     my $s1="$'";
     from_to($s1,"cp866","utf8");   
     $Data{$section}{$s} = $s1;  
     undef $s;
     undef $s1;
   }  
 }
 close(INIFILE);
 } 
 undef $section;
 undef $INIFILE;
 undef $filename;
 my $version=-1;
 foreach $package(keys %Data)
 {
 	if($Data{$package}{'PackageName'}=~/-srvk/)
 	{
      $version=$Data{$package}{'Version'};
      last; 		
 	}
 }
 $version=~s/\.//g;
 return $version;   	
}
sub IsSupport()
{
  my $res=1;
  my $packageName=`fw_printenv bpkg|sed -r "s/bpkg=//g"`;
  
  for($i=0;$i<5;$i++)
  {
    $packageName=`fw_printenv bpkg|sed -r "s/bpkg=//g"`;
    if(length($packageName)==0)
    {
    sleep(1);
    }
    else
    {
      last;
    }
  }
  chop $packageName;
  $packageName=~s/bpkg=//g;
  #Не получилось взять имя пакета СРВК из fv_printenv
  if(length($packageName)==0)
  {
  	my $version=Get_srvk_version();
  	my $ver_compare_result= Compare_Versions($version,"7.16.6");	
    if ($ver_compare_result==-1)#version <7.16.6
    {
  	  $res=0;
  	  return $res;
    }  	
  }
  else
  {
    my $output=`dpkg -p $packageName |grep Version:|sed -r "s/Version:\\s+//g"|sed -r "s/\\.//g"`;
    $ver_compare_result= Compare_Versions($output,"7.16.6");
    if (($ver_compare_result==-1) && (length($packageName)>0)) #version <7.16.6
    {
  	 $res=0;
    }  
  }
  return $res;	
}

sub Compare_Versions()
{
 (my $left,my $right)=@_;
  my @l=split(/\./,$left);
  my @r=split(/\./,$right);
  
  if(scalar(@l)>scalar(@r))
  {
  	for($i=0;$i<(scalar(@l)-scalar(@r));$i++)
  	{
  		push(@r,"0");
  	}
  }
  if(scalar(@r)>scalar(@l))
  {
  	for($i=0;$i<(scalar(@r)-scalar(@l));$i++)
  	{
  		push(@l,"0");
  	}  	
  }
  my $result;
 for ($i=0;$i<scalar(@l);$i++)
 {
    if($l[$i]>$r[$i])
    {
      $result=1;
      return $result;	
    } else
    {
	    if($l[$i]==$r[$i])
	    {
	      $result=0;
	    }
	    else
	    {
		    if($l[$i]<$r[$i])
		    {
		      $result=-1;
		      return $result;	
		    }	    	
	    }    	
    } 	
 } 
 return $result;	
}
