#!/usr/bin/perl
require './parse_file-lib.pl';
use WebminCore;
init_config();
use CGI::Lite;
use Time::Local;  
use POSIX qw(strftime);
$cgi=new CGI::Lite();
my %params       = $cgi->parse_form_data();
my %settings=LoadKrugSettings();
my $path=$settings{'GSW_SETTINGS'}.'trnames.ini'; 
my %Data=GetIniFileData($path);
foreach $s (keys %Data)
{
	if($Data{$s}{'Status'}==1)
	{
		$Data{$s}{'Status'}=0;
	}
}
foreach $param (keys %params)
{
	$_=$param;
	if(/smp(\d{1,5})/)
	{
      foreach $s (keys %Data)
      {
	    if($Data{$s}{'ID'}=="$1")
	    {
   	      $Data{$s}{'Status'}=1;
	    }
      }
	}
}
Save(%Data);

my $cmd="mkdir -p /tmp/krugdb_internal;export DEVLINK_BASE_PATH=\"/gsw/krugdb\";/gsw/get_trends ";
my $len=scalar(keys %params);
my $i=0;
 $params{'BeginData'}='"'.ConvertDateTimeToUTC($params{'BeginDataUTC'}).'"';
 $params{'EndData'}='"'.ConvertDateTimeToUTC($params{'EndDataUTC'}).'"';
 delete $params{'BeginDataUTC'};
 delete $params{'EndDataUTC'};
                                  
foreach $param (keys %params)
{
 my $p=$param;
 my $value="";
 if($p=~/smp(\d{1,5})/)
 {
 	$value="$1";
 	$p=~s/smp\d{1,5}/smp/;
 }
 else
 {
 	$value=$params{$param};
 }
  $p=~s/smp\d{1,5}/smp/;
 if($i==($len-1))
 {
 $cmd=$cmd." --".$p."=".$value;	 	
 }
 else
 {
   $cmd=$cmd." --".$p."=".$value." ";
 }	
 $i++;
}
my @output=`$cmd | iconv -f CP866 -t UTF-8`;
if($output[0]=~/RESULT=-1/)
{
     print ui_print_header();
	 if(scalar(@output>1))
	 {
	  my $errmsg=$output[1];
	  
	  $errmsg=~s/MSG=//g;
	  print <<PETE; 
	   <p align="center">
	     <font color="red">
	      <b>
	       Ошибка выполнения команды: $errmsg
	      </b>
	     </font>
	   <p>
PETE
 	
	 }
	 else
	 {	
	  print <<PETE; 
	   <p align="center">
	     <font color="red">
	      <b>
	       Ошибка выполнения команды: $cmd
	      </b>
	     </font>
	   <p>
PETE
	 }
}
else
{
  if($output[0]=~/FILE=(\S+)/)
  {
	my $reportfile="$1";
	$reportfile=~s/\/tmp/\//g;
	redirect($reportfile);
  }	
}   

sub ConvertDateTimeToUTC()
{
(my $DT)=@_;
 my @lt=localtime($DT/1000);
 $t=strftime("%d.%m.%Y %H:%M:%S",localtime($DT/1000));
 return $t;
}